/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSubPartitionElementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class OraclePartitionElementFactory
extends OBParserBaseVisitor<PartitionElement>
implements StatementFactory<PartitionElement> {
    private final ParserRuleContext parserRuleContext;

    public OraclePartitionElementFactory(@NonNull OBParser.Hash_partition_elementContext hashElementContext) {
        if (hashElementContext == null) {
            throw new NullPointerException("hashElementContext is marked non-null but is null");
        }
        this.parserRuleContext = hashElementContext;
    }

    public OraclePartitionElementFactory(@NonNull OBParser.Range_partition_elementContext rangeElementContext) {
        if (rangeElementContext == null) {
            throw new NullPointerException("rangeElementContext is marked non-null but is null");
        }
        this.parserRuleContext = rangeElementContext;
    }

    public OraclePartitionElementFactory(@NonNull OBParser.List_partition_elementContext listElementContext) {
        if (listElementContext == null) {
            throw new NullPointerException("listElementContext is marked non-null but is null");
        }
        this.parserRuleContext = listElementContext;
    }

    @Override
    public PartitionElement generate() {
        return (PartitionElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public PartitionElement visitHash_partition_element(OBParser.Hash_partition_elementContext ctx) {
        HashPartitionElement element = new HashPartitionElement((ParserRuleContext)ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()));
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        PartitionOptions options = OraclePartitionElementFactory.getPartitionOptions(ctx.hash_partition_attributes_option_list());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        return element;
    }

    @Override
    public PartitionElement visitRange_partition_element(OBParser.Range_partition_elementContext ctx) {
        List<Expression> rangeExprs = OracleSubPartitionElementFactory.getRangePartitionExprs(ctx.range_partition_expr());
        RangePartitionElement element = new RangePartitionElement(ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()), rangeExprs);
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        PartitionOptions options = OraclePartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option_list());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        return element;
    }

    @Override
    public PartitionElement visitList_partition_element(OBParser.List_partition_elementContext ctx) {
        List<Expression> listExprs = OracleSubPartitionElementFactory.getListPartitionExprs(ctx.list_partition_expr());
        ListPartitionElement element = new ListPartitionElement(ctx, OracleFromReferenceFactory.getRelation(ctx.relation_factor()), listExprs);
        element.setSchema(OracleFromReferenceFactory.getSchemaName(ctx.relation_factor()));
        element.setUserVariable(OracleFromReferenceFactory.getUserVariable(ctx.relation_factor()));
        PartitionOptions options = OraclePartitionElementFactory.getPartitionOptions(ctx.partition_attributes_option_list());
        if (ctx.INTNUM() != null && options == null) {
            options = new PartitionOptions(ctx.ID());
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.INTNUM() != null && options != null) {
            options.setId(Integer.valueOf(ctx.INTNUM().getText()));
        }
        element.setPartitionOptions(options);
        element.setSubPartitionElements((List)this.getSubPartitionElements(ctx.subpartition_list()));
        return element;
    }

    private List<SubPartitionElement> getSubPartitionElements(OBParser.Subpartition_listContext context) {
        if (context == null) {
            return null;
        }
        if (context.opt_hash_subpartition_list() != null) {
            return context.opt_hash_subpartition_list().hash_subpartition_list().hash_subpartition_element().stream().map(c -> new OracleSubPartitionElementFactory((OBParser.Hash_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        if (context.opt_range_subpartition_list() != null) {
            return context.opt_range_subpartition_list().range_subpartition_list().range_subpartition_element().stream().map(c -> new OracleSubPartitionElementFactory((OBParser.Range_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return context.opt_list_subpartition_list().list_subpartition_list().list_subpartition_element().stream().map(c -> new OracleSubPartitionElementFactory((OBParser.List_subpartition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
    }

    public static PartitionOptions getPartitionOptions(OBParser.Hash_partition_attributes_option_listContext ctx) {
        if (ctx == null) {
            return null;
        }
        PartitionOptions partitionOptions = new PartitionOptions(ctx);
        if (ctx.TABLESPACE() != null) {
            partitionOptions.setTableSpace(ctx.tablespace().getText());
        }
        if (ctx.compress_option() != null) {
            partitionOptions.merge(OraclePartitionElementFactory.getPartitionOptions(ctx.compress_option()));
        }
        return partitionOptions;
    }

    public static PartitionOptions getPartitionOptions(OBParser.Compress_optionContext ctx) {
        if (ctx == null) {
            return null;
        }
        PartitionOptions partitionOptions = new PartitionOptions(ctx);
        if (ctx.NOCOMPRESS() != null) {
            partitionOptions.setNoCompress(true);
            return partitionOptions;
        }
        CharStream input = ctx.getStart().getInputStream();
        String str = input.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
        int index = str.indexOf(ctx.COMPRESS().getText());
        if (index >= 0) {
            str = str.substring(index + ctx.COMPRESS().getText().length()).trim();
        }
        partitionOptions.setCompress(str);
        return partitionOptions;
    }

    public static PartitionOptions getPartitionOptions(OBParser.Partition_attributes_option_listContext ctx) {
        if (ctx == null) {
            return null;
        }
        PartitionOptions partitionOptions = new PartitionOptions(ctx);
        if (ctx.physical_attributes_option_list() != null) {
            partitionOptions.merge(OracleSubPartitionElementFactory.getPartitionOptions(ctx.physical_attributes_option_list()));
        }
        if (ctx.compress_option() != null) {
            partitionOptions.merge(OraclePartitionElementFactory.getPartitionOptions(ctx.compress_option()));
        }
        return partitionOptions;
    }
}

