/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.sequence.SequenceOptions;
import java.math.BigDecimal;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleSequenceOptionsFactory
extends OBParserBaseVisitor<SequenceOptions>
implements StatementFactory<SequenceOptions> {
    private final OBParser.Sequence_option_listContext sequenceOptionListContext;

    public OracleSequenceOptionsFactory(@NonNull OBParser.Sequence_option_listContext sequenceOptionListContext) {
        if (sequenceOptionListContext == null) {
            throw new NullPointerException("sequenceOptionListContext is marked non-null but is null");
        }
        this.sequenceOptionListContext = sequenceOptionListContext;
    }

    @Override
    public SequenceOptions generate() {
        return (SequenceOptions)this.visit((ParseTree)this.sequenceOptionListContext);
    }

    @Override
    public SequenceOptions visitSequence_option_list(OBParser.Sequence_option_listContext ctx) {
        SequenceOptions sequenceOptions = new SequenceOptions(ctx);
        ctx.sequence_option().forEach(context -> {
            if (context.NOMAXVALUE() != null) {
                sequenceOptions.setNoMaxValue(true);
            } else if (context.NOMINVALUE() != null) {
                sequenceOptions.setNoMinValue(true);
            } else if (context.CYCLE() != null) {
                sequenceOptions.setCycle(true);
            } else if (context.NOCYCLE() != null) {
                sequenceOptions.setNoCycle(true);
            } else if (context.CACHE() != null) {
                sequenceOptions.setCache(this.getNum(context.simple_num()));
            } else if (context.NOCACHE() != null) {
                sequenceOptions.setNoCache(true);
            } else if (context.ORDER() != null) {
                sequenceOptions.setOrder(true);
            } else if (context.NOORDER() != null) {
                sequenceOptions.setNoOrder(true);
            } else if (context.INCREMENT() != null && context.BY() != null) {
                sequenceOptions.setIncrementBy(this.getNum(context.simple_num()));
            } else if (context.MAXVALUE() != null) {
                sequenceOptions.setMaxValue(this.getNum(context.simple_num()));
            } else if (context.MINVALUE() != null) {
                sequenceOptions.setMinValue(this.getNum(context.simple_num()));
            } else if (context.START() != null && context.WITH() != null) {
                sequenceOptions.setStartWith(this.getNum(context.simple_num()));
            }
        });
        return sequenceOptions;
    }

    private BigDecimal getNum(OBParser.Simple_numContext context) {
        BigDecimal decimal = context.INTNUM() != null ? new BigDecimal(context.INTNUM().getText()) : new BigDecimal(context.DECIMAL_VAL().getText());
        return context.Minus() != null ? decimal.negate() : decimal;
    }
}

