/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleOrderByFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.WindowBody;
import com.oceanbase.tools.sqlparser.statement.common.WindowOffset;
import com.oceanbase.tools.sqlparser.statement.common.WindowOffsetType;
import com.oceanbase.tools.sqlparser.statement.common.WindowSpec;
import com.oceanbase.tools.sqlparser.statement.common.WindowType;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleWindowSpecFactory
extends OBParserBaseVisitor<WindowSpec>
implements StatementFactory<WindowSpec> {
    private final OBParser.Generalized_window_clauseContext windowClause;

    public OracleWindowSpecFactory(@NonNull OBParser.Generalized_window_clauseContext windowClause) {
        if (windowClause == null) {
            throw new NullPointerException("windowClause is marked non-null but is null");
        }
        this.windowClause = windowClause;
    }

    @Override
    public WindowSpec generate() {
        return (WindowSpec)this.visit((ParseTree)this.windowClause);
    }

    @Override
    public WindowSpec visitGeneralized_window_clause(OBParser.Generalized_window_clauseContext ctx) {
        WindowSpec window = new WindowSpec(ctx);
        if (ctx.PARTITION() != null) {
            window.setPartitionBy(ctx.expr_list().bit_expr().stream().map(e -> {
                OracleExpressionFactory factory = new OracleExpressionFactory((OBParser.Bit_exprContext)((Object)e));
                return (Expression)factory.generate();
            }).collect(Collectors.toList()));
        }
        if (ctx.order_by() != null) {
            OracleOrderByFactory factory = new OracleOrderByFactory(ctx.order_by());
            window.setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.win_window() != null) {
            WindowBody body;
            List offsets;
            OBParser.Win_windowContext win = ctx.win_window();
            WindowType windowType = WindowType.RANGE;
            if (win.win_rows_or_range().ROWS() != null) {
                windowType = WindowType.ROWS;
            }
            if ((offsets = win.win_bounding().stream().map(c -> {
                if (c.CURRENT() != null) {
                    return new WindowOffset((ParserRuleContext)c, WindowOffsetType.CURRENT_ROW);
                }
                OBParser.Win_intervalContext w = c.win_interval();
                WindowOffsetType type = WindowOffsetType.FOLLOWING;
                if (c.win_preceding_or_following().PRECEDING() != null) {
                    type = WindowOffsetType.PRECEDING;
                }
                WindowOffset offset = new WindowOffset((ParserRuleContext)c, type);
                OracleExpressionFactory factory = new OracleExpressionFactory(w.bit_expr());
                offset.setInterval((Expression)factory.generate());
                return offset;
            }).collect(Collectors.toList())).size() == 1) {
                body = new WindowBody(ctx.win_window(), windowType, (WindowOffset)offsets.get(0));
            } else if (offsets.size() == 2) {
                body = new WindowBody(ctx.win_window(), windowType, (WindowOffset)offsets.get(0), (WindowOffset)offsets.get(1));
            } else {
                throw new IllegalStateException("Window offset's count is illegal");
            }
            window.setBody(body);
        }
        return window;
    }
}

