/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement;

import com.oceanbase.tools.sqlparser.statement.Statement;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class BaseStatement
implements Statement {
    private final ParserRuleContext ruleNode;
    private final TerminalNode terminalNode;
    private final ParserRuleContext beginRule;
    private final TerminalNode beginNode;
    private final ParserRuleContext endRule;
    private final TerminalNode endNode;

    protected BaseStatement() {
        this(null, null, null, null, null, null);
    }

    protected BaseStatement(TerminalNode terminalNode) {
        this(null, terminalNode, null, null, null, null);
    }

    protected BaseStatement(ParserRuleContext ruleNode) {
        this(ruleNode, null, null, null, null, null);
    }

    protected BaseStatement(ParserRuleContext beginRule, ParserRuleContext endRule) {
        this(null, null, beginRule, endRule, null, null);
    }

    protected BaseStatement(ParserRuleContext beginRule, TerminalNode endNode) {
        this(null, null, beginRule, null, null, endNode);
    }

    protected BaseStatement(TerminalNode beginNode, TerminalNode endNode) {
        this(null, null, null, null, beginNode, endNode);
    }

    protected BaseStatement(TerminalNode beginNode, ParserRuleContext endRule) {
        this(null, null, null, endRule, beginNode, null);
    }

    private BaseStatement(ParserRuleContext ruleNode, TerminalNode terminalNode, ParserRuleContext beginRule, ParserRuleContext endRule, TerminalNode beginNode, TerminalNode endNode) {
        this.ruleNode = ruleNode;
        this.terminalNode = terminalNode;
        this.endNode = endNode;
        this.endRule = endRule;
        this.beginNode = beginNode;
        this.beginRule = beginRule;
    }

    @Override
    public String getText() {
        Token start;
        if (this.ruleNode != null) {
            Token start2 = this.ruleNode.getStart();
            Token offset = this.ruleNode.getStop();
            if (start2 == null || offset == null) {
                return null;
            }
            CharStream charStream = start2.getTokenSource().getInputStream();
            if (charStream == null) {
                return null;
            }
            return charStream.getText(Interval.of((int)start2.getStartIndex(), (int)offset.getStopIndex()));
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getText();
        }
        CharStream charStream = null;
        if (this.beginNode != null) {
            charStream = this.beginNode.getSymbol().getTokenSource().getInputStream();
        } else if (this.beginRule != null && (start = this.beginRule.getStart()) != null) {
            charStream = start.getTokenSource().getInputStream();
        }
        int startIndex = this.getStart();
        int endIndex = this.getStop();
        if (startIndex == -1 || endIndex == -1 || charStream == null) {
            return null;
        }
        return charStream.getText(Interval.of((int)startIndex, (int)endIndex));
    }

    @Override
    public int getStart() {
        Token start;
        if (this.ruleNode != null) {
            return this.ruleNode.getStart().getStartIndex();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getStartIndex();
        }
        if (this.beginNode != null) {
            return this.beginNode.getSymbol().getStartIndex();
        }
        if (this.beginRule != null && (start = this.beginRule.getStart()) != null) {
            return start.getStartIndex();
        }
        return -1;
    }

    @Override
    public int getStop() {
        Token end;
        if (this.ruleNode != null) {
            return this.ruleNode.getStop().getStopIndex();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getStopIndex();
        }
        if (this.endNode != null) {
            return this.endNode.getSymbol().getStopIndex();
        }
        if (this.endRule != null && (end = this.endRule.getStop()) != null) {
            return end.getStopIndex();
        }
        return -1;
    }

    @Override
    public int getLine() {
        Token start;
        if (this.ruleNode != null) {
            Token offset = this.ruleNode.getStart();
            if (offset == null) {
                return -1;
            }
            return offset.getLine();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getLine();
        }
        if (this.beginNode != null) {
            return this.beginNode.getSymbol().getLine();
        }
        if (this.beginRule != null && (start = this.beginRule.getStart()) != null) {
            return start.getLine();
        }
        return -1;
    }

    @Override
    public int getCharPositionInLine() {
        Token start;
        if (this.ruleNode != null) {
            Token offset = this.ruleNode.getStart();
            if (offset == null) {
                return -1;
            }
            return offset.getCharPositionInLine();
        }
        if (this.terminalNode != null) {
            return this.terminalNode.getSymbol().getCharPositionInLine();
        }
        if (this.beginNode != null) {
            return this.beginNode.getSymbol().getCharPositionInLine();
        }
        if (this.beginRule != null && (start = this.beginRule.getStart()) != null) {
            return start.getCharPositionInLine();
        }
        return -1;
    }
}

