/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class CharacterType
extends BaseStatement
implements DataType {
    private String charset;
    private String collation;
    private boolean binary;
    private final BigDecimal length;
    private String lengthOption;
    private final String typeName;

    public CharacterType(@NonNull ParserRuleContext context, @NonNull String typeName, BigDecimal length) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        this.length = length;
        this.typeName = typeName;
    }

    public CharacterType(@NonNull ParserRuleContext context, @NonNull CharacterType other) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.charset = other.charset;
        this.collation = other.collation;
        this.binary = other.binary;
        this.length = other.length;
        this.lengthOption = other.lengthOption;
        this.typeName = other.typeName;
    }

    public CharacterType(@NonNull String typeName, BigDecimal length) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        this.length = length;
        this.typeName = typeName;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public List<String> getArguments() {
        if (this.length == null) {
            return Collections.emptyList();
        }
        StringBuilder builder = new StringBuilder(this.length.toString());
        if (this.lengthOption != null) {
            builder.append(" ").append(this.lengthOption);
        }
        return Collections.singletonList(builder.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName().toUpperCase());
        if (this.length != null) {
            builder.append("(").append(this.length.toString());
            if (this.lengthOption != null) {
                builder.append(" ").append(this.lengthOption);
            }
            builder.append(")");
        }
        if (this.binary) {
            builder.append(" ").append("BINARY");
        }
        if (this.charset != null) {
            builder.append(" ").append("CHARSET").append(" ").append(this.charset);
        }
        if (this.collation != null) {
            builder.append(" ").append("COLLATE").append(" ").append(this.collation);
        }
        return builder.toString();
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollation() {
        return this.collation;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public String getLengthOption() {
        return this.lengthOption;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setLengthOption(String lengthOption) {
        this.lengthOption = lengthOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharacterType)) {
            return false;
        }
        CharacterType other = (CharacterType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        if (this.isBinary() != other.isBinary()) {
            return false;
        }
        BigDecimal this$length = this.getLength();
        BigDecimal other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        String this$lengthOption = this.getLengthOption();
        String other$lengthOption = other.getLengthOption();
        if (this$lengthOption == null ? other$lengthOption != null : !this$lengthOption.equals(other$lengthOption)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CharacterType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        result = result * 59 + (this.isBinary() ? 79 : 97);
        BigDecimal $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        String $lengthOption = this.getLengthOption();
        result = result * 59 + ($lengthOption == null ? 43 : $lengthOption.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }
}

