/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang3.Validate;

public class TimestampType
extends BaseStatement
implements DataType {
    private final boolean withTimeZone;
    private final boolean withLocalTimeZone;
    private final BigDecimal precision;

    public TimestampType(@NonNull ParserRuleContext context, BigDecimal precision, boolean withTimeZone, boolean withLocalTimeZone) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        Validate.isTrue((!withLocalTimeZone || !withTimeZone ? 1 : 0) != 0);
        this.precision = precision;
        this.withLocalTimeZone = withLocalTimeZone;
        this.withTimeZone = withTimeZone;
    }

    public TimestampType(BigDecimal precision, boolean withTimeZone, boolean withLocalTimeZone) {
        Validate.isTrue((!withLocalTimeZone || !withTimeZone ? 1 : 0) != 0);
        this.precision = precision;
        this.withLocalTimeZone = withLocalTimeZone;
        this.withTimeZone = withTimeZone;
    }

    @Override
    public String getName() {
        if (this.withTimeZone) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        if (this.withLocalTimeZone) {
            return "TIMESTAMP WITH LOCAL TIME ZONE";
        }
        return "TIMESTAMP";
    }

    @Override
    public List<String> getArguments() {
        if (this.precision == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.precision.toString());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TIMESTAMP");
        if (this.precision != null) {
            builder.append("(").append(this.precision.toString()).append(")");
        }
        if (this.withTimeZone) {
            builder.append(" WITH TIME ZONE");
        } else if (this.withLocalTimeZone) {
            builder.append(" WITH LOCAL TIME ZONE");
        }
        return builder.toString();
    }

    public boolean isWithTimeZone() {
        return this.withTimeZone;
    }

    public boolean isWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    public BigDecimal getPrecision() {
        return this.precision;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampType)) {
            return false;
        }
        TimestampType other = (TimestampType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWithTimeZone() != other.isWithTimeZone()) {
            return false;
        }
        if (this.isWithLocalTimeZone() != other.isWithLocalTimeZone()) {
            return false;
        }
        BigDecimal this$precision = this.getPrecision();
        BigDecimal other$precision = other.getPrecision();
        return !(this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimestampType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWithTimeZone() ? 79 : 97);
        result = result * 59 + (this.isWithLocalTimeZone() ? 79 : 97);
        BigDecimal $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        return result;
    }
}

