/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.WindowOffset;
import com.oceanbase.tools.sqlparser.statement.common.WindowType;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class WindowBody
extends BaseStatement {
    private final WindowType type;
    private final WindowOffset begin;
    private final WindowOffset end;
    private final WindowOffset offset;

    public WindowBody(@NonNull ParserRuleContext context, @NonNull WindowType type, @NonNull WindowOffset begin, @NonNull WindowOffset end) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.type = type;
        this.begin = begin;
        this.end = end;
        this.offset = null;
    }

    public WindowBody(@NonNull ParserRuleContext context, @NonNull WindowType type, @NonNull WindowOffset offset) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.begin = null;
        this.end = null;
    }

    public WindowBody(@NonNull WindowType type, @NonNull WindowOffset begin, @NonNull WindowOffset end) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.type = type;
        this.begin = begin;
        this.end = end;
        this.offset = null;
    }

    public WindowBody(@NonNull WindowType type, @NonNull WindowOffset offset) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.type = type;
        this.offset = offset;
        this.begin = null;
        this.end = null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type.name());
        if (this.begin != null && this.end != null) {
            return builder.append(" BETWEEN ").append(this.begin.toString()).append(" AND ").append(this.end.toString()).toString();
        }
        if (this.offset != null) {
            return builder.append(" ").append(this.offset.toString()).toString();
        }
        return builder.toString();
    }

    public WindowType getType() {
        return this.type;
    }

    public WindowOffset getBegin() {
        return this.begin;
    }

    public WindowOffset getEnd() {
        return this.end;
    }

    public WindowOffset getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowBody)) {
            return false;
        }
        WindowBody other = (WindowBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WindowType this$type = this.getType();
        WindowType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        WindowOffset this$begin = this.getBegin();
        WindowOffset other$begin = other.getBegin();
        if (this$begin == null ? other$begin != null : !((Object)this$begin).equals(other$begin)) {
            return false;
        }
        WindowOffset this$end = this.getEnd();
        WindowOffset other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        WindowOffset this$offset = this.getOffset();
        WindowOffset other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WindowBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WindowType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        WindowOffset $begin = this.getBegin();
        result = result * 59 + ($begin == null ? 43 : ((Object)$begin).hashCode());
        WindowOffset $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        WindowOffset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }
}

