/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.WindowBody;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class WindowSpec
extends BaseStatement {
    private OrderBy orderBy;
    private List<Expression> partitionBy = new ArrayList<Expression>();
    private String name;
    private WindowBody body;

    public WindowSpec(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public WindowSpec(@NonNull ParserRuleContext context, @NonNull WindowSpec other) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.orderBy = other.orderBy;
        this.partitionBy = other.partitionBy;
        this.name = other.name;
        this.body = other.body;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(this.name);
        }
        if (CollectionUtils.isNotEmpty(this.partitionBy)) {
            String exprList = this.partitionBy.stream().map(Object::toString).collect(Collectors.joining(","));
            builder.append(" PARTITION BY ").append(exprList);
        }
        if (this.orderBy != null) {
            builder.append(" ").append(this.orderBy.toString());
        }
        if (this.body != null) {
            builder.append(" ").append(this.body.toString());
        }
        if (builder.length() != 0 && builder.toString().startsWith(" ")) {
            return builder.substring(1);
        }
        return builder.toString();
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setPartitionBy(List<Expression> partitionBy) {
        this.partitionBy = partitionBy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBody(WindowBody body) {
        this.body = body;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public String getName() {
        return this.name;
    }

    public WindowBody getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowSpec)) {
            return false;
        }
        WindowSpec other = (WindowSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OrderBy this$orderBy = this.getOrderBy();
        OrderBy other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        List<Expression> this$partitionBy = this.getPartitionBy();
        List<Expression> other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !((Object)this$partitionBy).equals(other$partitionBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        WindowBody this$body = this.getBody();
        WindowBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WindowSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OrderBy $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        List<Expression> $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : ((Object)$partitionBy).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        WindowBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    public WindowSpec() {
    }
}

