/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common.mysql;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class CollectionType
extends BaseStatement
implements DataType {
    private String charset;
    private String collation;
    private boolean binary;
    private final String typeName;
    private final List<String> stringList;

    public CollectionType(@NonNull ParserRuleContext context, @NonNull String typeName, @NonNull List<String> stringList) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (stringList == null) {
            throw new NullPointerException("stringList is marked non-null but is null");
        }
        this.typeName = typeName;
        this.stringList = stringList;
    }

    public CollectionType(@NonNull String typeName, @NonNull List<String> stringList) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (stringList == null) {
            throw new NullPointerException("stringList is marked non-null but is null");
        }
        this.stringList = stringList;
        this.typeName = typeName;
    }

    @Override
    public String getName() {
        return this.typeName.toUpperCase();
    }

    @Override
    public List<String> getArguments() {
        return this.stringList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName());
        builder.append("(").append(String.join((CharSequence)",", this.stringList)).append(")");
        if (this.binary) {
            builder.append(" ").append("BINARY");
        }
        if (this.charset != null) {
            builder.append(" ").append("CHARSET").append(" ").append(this.charset);
        }
        if (this.collation != null) {
            builder.append(" ").append("COLLATE").append(" ").append(this.collation);
        }
        return builder.toString();
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollation() {
        return this.collation;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionType)) {
            return false;
        }
        CollectionType other = (CollectionType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        if (this.isBinary() != other.isBinary()) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<String> this$stringList = this.getStringList();
        List<String> other$stringList = other.getStringList();
        return !(this$stringList == null ? other$stringList != null : !((Object)this$stringList).equals(other$stringList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        result = result * 59 + (this.isBinary() ? 79 : 97);
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<String> $stringList = this.getStringList();
        result = result * 59 + ($stringList == null ? 43 : ((Object)$stringList).hashCode());
        return result;
    }
}

