/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class IntervalType
extends BaseStatement
implements DataType {
    private final boolean yearToMonth;
    private final boolean dayToSecond;
    private final BigDecimal yearPrecision;
    private final BigDecimal dayPrecision;
    private final BigDecimal secondPrecision;

    public IntervalType(@NonNull ParserRuleContext context, BigDecimal yearPrecision) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.yearToMonth = true;
        this.dayToSecond = false;
        this.yearPrecision = yearPrecision;
        this.dayPrecision = null;
        this.secondPrecision = null;
    }

    public IntervalType(@NonNull ParserRuleContext context, BigDecimal dayPrecision, BigDecimal secondPrecision) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.yearToMonth = false;
        this.dayToSecond = true;
        this.yearPrecision = null;
        this.dayPrecision = dayPrecision;
        this.secondPrecision = secondPrecision;
    }

    public IntervalType(BigDecimal yearPrecision) {
        this.yearToMonth = true;
        this.dayToSecond = false;
        this.yearPrecision = yearPrecision;
        this.dayPrecision = null;
        this.secondPrecision = null;
    }

    public IntervalType(BigDecimal dayPrecision, BigDecimal secondPrecision) {
        this.yearToMonth = false;
        this.dayToSecond = true;
        this.yearPrecision = null;
        this.dayPrecision = dayPrecision;
        this.secondPrecision = secondPrecision;
    }

    @Override
    public String getName() {
        if (this.dayToSecond) {
            return "INTERVAL DAY TO SECOND";
        }
        return "INTERVAL YEAR TO MONTH";
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.yearPrecision != null) {
            args.add(this.yearPrecision.toString());
        }
        if (this.dayPrecision != null) {
            args.add(this.dayPrecision.toString());
        }
        if (this.secondPrecision != null) {
            args.add(this.secondPrecision.toString());
        }
        return args;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("INTERVAL");
        if (this.yearToMonth) {
            builder.append(" ").append("YEAR");
            if (this.yearPrecision != null) {
                builder.append("(").append(this.yearPrecision.toString()).append(")");
            }
            builder.append(" TO MONTH");
        } else if (this.dayToSecond) {
            builder.append(" ").append("DAY");
            if (this.dayPrecision != null) {
                builder.append("(").append(this.dayPrecision.toString()).append(")");
            }
            builder.append(" TO SECOND");
            if (this.secondPrecision != null) {
                builder.append("(").append(this.secondPrecision.toString()).append(")");
            }
        }
        return builder.toString();
    }

    public boolean isYearToMonth() {
        return this.yearToMonth;
    }

    public boolean isDayToSecond() {
        return this.dayToSecond;
    }

    public BigDecimal getYearPrecision() {
        return this.yearPrecision;
    }

    public BigDecimal getDayPrecision() {
        return this.dayPrecision;
    }

    public BigDecimal getSecondPrecision() {
        return this.secondPrecision;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntervalType)) {
            return false;
        }
        IntervalType other = (IntervalType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isYearToMonth() != other.isYearToMonth()) {
            return false;
        }
        if (this.isDayToSecond() != other.isDayToSecond()) {
            return false;
        }
        BigDecimal this$yearPrecision = this.getYearPrecision();
        BigDecimal other$yearPrecision = other.getYearPrecision();
        if (this$yearPrecision == null ? other$yearPrecision != null : !((Object)this$yearPrecision).equals(other$yearPrecision)) {
            return false;
        }
        BigDecimal this$dayPrecision = this.getDayPrecision();
        BigDecimal other$dayPrecision = other.getDayPrecision();
        if (this$dayPrecision == null ? other$dayPrecision != null : !((Object)this$dayPrecision).equals(other$dayPrecision)) {
            return false;
        }
        BigDecimal this$secondPrecision = this.getSecondPrecision();
        BigDecimal other$secondPrecision = other.getSecondPrecision();
        return !(this$secondPrecision == null ? other$secondPrecision != null : !((Object)this$secondPrecision).equals(other$secondPrecision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntervalType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isYearToMonth() ? 79 : 97);
        result = result * 59 + (this.isDayToSecond() ? 79 : 97);
        BigDecimal $yearPrecision = this.getYearPrecision();
        result = result * 59 + ($yearPrecision == null ? 43 : ((Object)$yearPrecision).hashCode());
        BigDecimal $dayPrecision = this.getDayPrecision();
        result = result * 59 + ($dayPrecision == null ? 43 : ((Object)$dayPrecision).hashCode());
        BigDecimal $secondPrecision = this.getSecondPrecision();
        result = result * 59 + ($secondPrecision == null ? 43 : ((Object)$secondPrecision).hashCode());
        return result;
    }
}

