/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.sequence.SequenceOptions;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class GenerateOption
extends BaseStatement {
    private String generateOption;
    private Type type;
    private final Expression asExpression;
    private final boolean asIdentity;
    private final SequenceOptions sequenceOptions;

    public GenerateOption(@NonNull ParserRuleContext context, @NonNull Expression asExpression) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (asExpression == null) {
            throw new NullPointerException("asExpression is marked non-null but is null");
        }
        this.asExpression = asExpression;
        this.asIdentity = false;
        this.sequenceOptions = null;
    }

    public GenerateOption(@NonNull ParserRuleContext context, SequenceOptions sequenceOptions) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.asExpression = null;
        this.asIdentity = true;
        this.sequenceOptions = sequenceOptions;
    }

    public GenerateOption(@NonNull Expression asExpression) {
        if (asExpression == null) {
            throw new NullPointerException("asExpression is marked non-null but is null");
        }
        this.asExpression = asExpression;
        this.asIdentity = false;
        this.sequenceOptions = null;
    }

    public GenerateOption(SequenceOptions sequenceOptions) {
        this.asExpression = null;
        this.asIdentity = true;
        this.sequenceOptions = sequenceOptions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.generateOption != null) {
            builder.append(" GENERATED ").append(this.generateOption.toUpperCase());
        }
        builder.append(" AS");
        if (this.asExpression != null) {
            builder.append(" (").append(this.asExpression.toString()).append(")");
        } else if (this.asIdentity) {
            builder.append(" IDENTITY");
            if (this.sequenceOptions != null) {
                builder.append(" ").append(this.sequenceOptions);
            }
        }
        if (this.type != null) {
            builder.append(" ").append(this.type.name());
        }
        return builder.substring(1);
    }

    public String getGenerateOption() {
        return this.generateOption;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getAsExpression() {
        return this.asExpression;
    }

    public boolean isAsIdentity() {
        return this.asIdentity;
    }

    public SequenceOptions getSequenceOptions() {
        return this.sequenceOptions;
    }

    public void setGenerateOption(String generateOption) {
        this.generateOption = generateOption;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateOption)) {
            return false;
        }
        GenerateOption other = (GenerateOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$generateOption = this.getGenerateOption();
        String other$generateOption = other.getGenerateOption();
        if (this$generateOption == null ? other$generateOption != null : !this$generateOption.equals(other$generateOption)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Expression this$asExpression = this.getAsExpression();
        Expression other$asExpression = other.getAsExpression();
        if (this$asExpression == null ? other$asExpression != null : !this$asExpression.equals(other$asExpression)) {
            return false;
        }
        if (this.isAsIdentity() != other.isAsIdentity()) {
            return false;
        }
        SequenceOptions this$sequenceOptions = this.getSequenceOptions();
        SequenceOptions other$sequenceOptions = other.getSequenceOptions();
        return !(this$sequenceOptions == null ? other$sequenceOptions != null : !((Object)this$sequenceOptions).equals(other$sequenceOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerateOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $generateOption = this.getGenerateOption();
        result = result * 59 + ($generateOption == null ? 43 : $generateOption.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Expression $asExpression = this.getAsExpression();
        result = result * 59 + ($asExpression == null ? 43 : $asExpression.hashCode());
        result = result * 59 + (this.isAsIdentity() ? 79 : 97);
        SequenceOptions $sequenceOptions = this.getSequenceOptions();
        result = result * 59 + ($sequenceOptions == null ? 43 : ((Object)$sequenceOptions).hashCode());
        return result;
    }

    public static enum Type {
        VIRTUAL,
        STORED;

    }
}

