/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.createtable.BasePartitionElement;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class HashPartitionElement
extends BasePartitionElement {
    public HashPartitionElement(@NonNull ParserRuleContext context, String relation) {
        super(context, relation);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public HashPartitionElement(String relation) {
        super(relation);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION");
        if (this.getRelationFactor() != null) {
            builder.append(" ").append(this.getRelationFactor());
        }
        if (this.getOptions() != null) {
            builder.append(" ").append(this.getOptions());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getSubPartitionElements())) {
            builder.append(" (\n\t\t").append(this.getSubPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t\t"))).append("\n\t)");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashPartitionElement)) {
            return false;
        }
        HashPartitionElement other = (HashPartitionElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HashPartitionElement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

