/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class OutOfLineConstraint
extends BaseStatement
implements TableElement {
    private String indexName;
    private String constraintName;
    private boolean uniqueKey;
    private boolean primaryKey;
    private final ConstraintState state;
    private final List<SortColumn> columns;

    public OutOfLineConstraint(@NonNull ParserRuleContext context, ConstraintState state, @NonNull List<SortColumn> columns) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.state = state;
        this.columns = columns;
    }

    public OutOfLineConstraint(@NonNull ParserRuleContext context, @NonNull OutOfLineConstraint target) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.indexName = target.indexName;
        this.state = target.state;
        this.uniqueKey = target.uniqueKey;
        this.primaryKey = target.primaryKey;
        this.columns = target.columns;
        this.constraintName = target.constraintName;
    }

    public OutOfLineConstraint(ConstraintState state, @NonNull List<SortColumn> columns) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.state = state;
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder;
        if (this.constraintName != null) {
            builder = new StringBuilder(" CONSTRAINT");
            builder.append(" ").append(this.constraintName);
        } else {
            builder = new StringBuilder();
        }
        if (this.primaryKey) {
            builder.append(" PRIMARY KEY");
        } else if (this.uniqueKey) {
            builder.append(" UNIQUE");
        }
        if (this.indexName != null) {
            builder.append(" ").append(this.indexName);
        }
        if (CollectionUtils.isNotEmpty(this.columns)) {
            builder.append("(").append(this.getColumns().stream().map(SortColumn::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.state != null) {
            builder.append(" ").append(this.state);
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public boolean isUniqueKey() {
        return this.uniqueKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public ConstraintState getState() {
        return this.state;
    }

    public List<SortColumn> getColumns() {
        return this.columns;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setUniqueKey(boolean uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutOfLineConstraint)) {
            return false;
        }
        OutOfLineConstraint other = (OutOfLineConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$constraintName = this.getConstraintName();
        String other$constraintName = other.getConstraintName();
        if (this$constraintName == null ? other$constraintName != null : !this$constraintName.equals(other$constraintName)) {
            return false;
        }
        if (this.isUniqueKey() != other.isUniqueKey()) {
            return false;
        }
        if (this.isPrimaryKey() != other.isPrimaryKey()) {
            return false;
        }
        ConstraintState this$state = this.getState();
        ConstraintState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        List<SortColumn> this$columns = this.getColumns();
        List<SortColumn> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutOfLineConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $constraintName = this.getConstraintName();
        result = result * 59 + ($constraintName == null ? 43 : $constraintName.hashCode());
        result = result * 59 + (this.isUniqueKey() ? 79 : 97);
        result = result * 59 + (this.isPrimaryKey() ? 79 : 97);
        ConstraintState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        List<SortColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }
}

