/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PartitionOptions
extends BaseOptions {
    private Integer id;
    private Boolean noCompress;
    private String compress;
    private String engine;
    private Integer iniTrans;
    private Integer maxTrans;
    private Integer pctFree;
    private Integer pctUsed;
    private List<String> storage;
    private String tableSpace;

    public PartitionOptions(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public PartitionOptions(@NonNull TerminalNode node) {
        super(node);
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.id != null) {
            builder.append(" ID ").append(this.id);
        }
        if (this.pctFree != null) {
            builder.append(" PCTFREE=").append(this.pctFree);
        }
        if (this.pctUsed != null) {
            builder.append(" PCTUSED ").append(this.pctUsed);
        }
        if (this.iniTrans != null) {
            builder.append(" INITRANS ").append(this.iniTrans);
        }
        if (this.maxTrans != null) {
            builder.append(" MAXTRANS ").append(this.maxTrans);
        }
        if (this.storage != null) {
            builder.append(" STORAGE(").append(String.join((CharSequence)" ", this.storage)).append(")");
        }
        if (this.tableSpace != null) {
            builder.append(" TABLESPACE ").append(this.tableSpace);
        }
        if (this.engine != null) {
            builder.append(" ENGINE=").append(this.engine);
        }
        if (Boolean.TRUE.equals(this.noCompress)) {
            builder.append(" NOCOMPRESS");
        }
        if (this.compress != null) {
            builder.append(" COMPRESS ").append(this.getCompress());
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public Integer getId() {
        return this.id;
    }

    public Boolean getNoCompress() {
        return this.noCompress;
    }

    public String getCompress() {
        return this.compress;
    }

    public String getEngine() {
        return this.engine;
    }

    public Integer getIniTrans() {
        return this.iniTrans;
    }

    public Integer getMaxTrans() {
        return this.maxTrans;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public Integer getPctUsed() {
        return this.pctUsed;
    }

    public List<String> getStorage() {
        return this.storage;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setNoCompress(Boolean noCompress) {
        this.noCompress = noCompress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setIniTrans(Integer iniTrans) {
        this.iniTrans = iniTrans;
    }

    public void setMaxTrans(Integer maxTrans) {
        this.maxTrans = maxTrans;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public void setPctUsed(Integer pctUsed) {
        this.pctUsed = pctUsed;
    }

    public void setStorage(List<String> storage) {
        this.storage = storage;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }

    public PartitionOptions() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionOptions)) {
            return false;
        }
        PartitionOptions other = (PartitionOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$noCompress = this.getNoCompress();
        Boolean other$noCompress = other.getNoCompress();
        if (this$noCompress == null ? other$noCompress != null : !((Object)this$noCompress).equals(other$noCompress)) {
            return false;
        }
        String this$compress = this.getCompress();
        String other$compress = other.getCompress();
        if (this$compress == null ? other$compress != null : !this$compress.equals(other$compress)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Integer this$iniTrans = this.getIniTrans();
        Integer other$iniTrans = other.getIniTrans();
        if (this$iniTrans == null ? other$iniTrans != null : !((Object)this$iniTrans).equals(other$iniTrans)) {
            return false;
        }
        Integer this$maxTrans = this.getMaxTrans();
        Integer other$maxTrans = other.getMaxTrans();
        if (this$maxTrans == null ? other$maxTrans != null : !((Object)this$maxTrans).equals(other$maxTrans)) {
            return false;
        }
        Integer this$pctFree = this.getPctFree();
        Integer other$pctFree = other.getPctFree();
        if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
            return false;
        }
        Integer this$pctUsed = this.getPctUsed();
        Integer other$pctUsed = other.getPctUsed();
        if (this$pctUsed == null ? other$pctUsed != null : !((Object)this$pctUsed).equals(other$pctUsed)) {
            return false;
        }
        List<String> this$storage = this.getStorage();
        List<String> other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        String this$tableSpace = this.getTableSpace();
        String other$tableSpace = other.getTableSpace();
        return !(this$tableSpace == null ? other$tableSpace != null : !this$tableSpace.equals(other$tableSpace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $noCompress = this.getNoCompress();
        result = result * 59 + ($noCompress == null ? 43 : ((Object)$noCompress).hashCode());
        String $compress = this.getCompress();
        result = result * 59 + ($compress == null ? 43 : $compress.hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Integer $iniTrans = this.getIniTrans();
        result = result * 59 + ($iniTrans == null ? 43 : ((Object)$iniTrans).hashCode());
        Integer $maxTrans = this.getMaxTrans();
        result = result * 59 + ($maxTrans == null ? 43 : ((Object)$maxTrans).hashCode());
        Integer $pctFree = this.getPctFree();
        result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
        Integer $pctUsed = this.getPctUsed();
        result = result * 59 + ($pctUsed == null ? 43 : ((Object)$pctUsed).hashCode());
        List<String> $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        String $tableSpace = this.getTableSpace();
        result = result * 59 + ($tableSpace == null ? 43 : $tableSpace.hashCode());
        return result;
    }
}

