/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.SortDirection;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SortNullPosition;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class SortColumn
extends BaseStatement {
    private SortDirection direction;
    private SortNullPosition nullPosition;
    private Integer length;
    private Integer id;
    private final Expression column;

    public SortColumn(@NonNull ParserRuleContext context, @NonNull Expression column) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
    }

    public SortColumn(@NonNull Expression column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.column.toString());
        if (this.length != null) {
            builder.append("(").append(this.length).append(")");
        }
        if (this.direction != null) {
            builder.append(" ").append(this.direction.name());
        }
        if (this.nullPosition != null) {
            builder.append(" ").append("NULLS ").append(this.nullPosition == SortNullPosition.LAST ? "LAST" : "FIRST");
        }
        if (this.id != null) {
            builder.append(" ").append("ID ").append(this.id);
        }
        return builder.toString();
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    public SortNullPosition getNullPosition() {
        return this.nullPosition;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getId() {
        return this.id;
    }

    public Expression getColumn() {
        return this.column;
    }

    public void setDirection(SortDirection direction) {
        this.direction = direction;
    }

    public void setNullPosition(SortNullPosition nullPosition) {
        this.nullPosition = nullPosition;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortColumn)) {
            return false;
        }
        SortColumn other = (SortColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SortDirection this$direction = this.getDirection();
        SortDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        SortNullPosition this$nullPosition = this.getNullPosition();
        SortNullPosition other$nullPosition = other.getNullPosition();
        if (this$nullPosition == null ? other$nullPosition != null : !((Object)((Object)this$nullPosition)).equals((Object)other$nullPosition)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Expression this$column = this.getColumn();
        Expression other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SortDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        SortNullPosition $nullPosition = this.getNullPosition();
        result = result * 59 + ($nullPosition == null ? 43 : ((Object)((Object)$nullPosition)).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Expression $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }
}

