/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.WhenClause;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class CaseWhen
extends BaseExpression {
    private Expression caseValue;
    private Expression caseDefault;
    private final List<WhenClause> whenClauses;

    public CaseWhen(@NonNull ParserRuleContext context, @NonNull List<WhenClause> whenClauses) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (whenClauses == null) {
            throw new NullPointerException("whenClauses is marked non-null but is null");
        }
        this.whenClauses = whenClauses;
    }

    public CaseWhen(@NonNull List<WhenClause> whenClauses) {
        if (whenClauses == null) {
            throw new NullPointerException("whenClauses is marked non-null but is null");
        }
        this.whenClauses = whenClauses;
    }

    @Override
    public String doToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE");
        if (this.caseValue != null) {
            builder.append(" ").append(this.caseValue);
        }
        if (CollectionUtils.isNotEmpty(this.whenClauses)) {
            builder.append("\n\t").append(this.whenClauses.stream().map(BaseExpression::toString).collect(Collectors.joining("\n\t")));
        }
        if (this.caseDefault != null) {
            builder.append("\n\tELSE ").append(this.caseDefault);
        }
        return builder.append("\nEND").toString();
    }

    public void setCaseValue(Expression caseValue) {
        this.caseValue = caseValue;
    }

    public void setCaseDefault(Expression caseDefault) {
        this.caseDefault = caseDefault;
    }

    public Expression getCaseValue() {
        return this.caseValue;
    }

    public Expression getCaseDefault() {
        return this.caseDefault;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaseWhen)) {
            return false;
        }
        CaseWhen other = (CaseWhen)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$caseValue = this.getCaseValue();
        Expression other$caseValue = other.getCaseValue();
        if (this$caseValue == null ? other$caseValue != null : !this$caseValue.equals(other$caseValue)) {
            return false;
        }
        Expression this$caseDefault = this.getCaseDefault();
        Expression other$caseDefault = other.getCaseDefault();
        if (this$caseDefault == null ? other$caseDefault != null : !this$caseDefault.equals(other$caseDefault)) {
            return false;
        }
        List<WhenClause> this$whenClauses = this.getWhenClauses();
        List<WhenClause> other$whenClauses = other.getWhenClauses();
        return !(this$whenClauses == null ? other$whenClauses != null : !((Object)this$whenClauses).equals(other$whenClauses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CaseWhen;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $caseValue = this.getCaseValue();
        result = result * 59 + ($caseValue == null ? 43 : $caseValue.hashCode());
        Expression $caseDefault = this.getCaseDefault();
        result = result * 59 + ($caseDefault == null ? 43 : $caseDefault.hashCode());
        List<WhenClause> $whenClauses = this.getWhenClauses();
        result = result * 59 + ($whenClauses == null ? 43 : ((Object)$whenClauses).hashCode());
        return result;
    }
}

