/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import lombok.NonNull;

public class ExpressionParam
extends FunctionParam {
    private final Expression target;

    public ExpressionParam(@NonNull Expression target) {
        this(target, null);
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
    }

    public ExpressionParam(@NonNull Expression target, String alias) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
        if (alias != null) {
            this.addOption(new ConstExpression(alias));
        }
    }

    @Override
    public String getText() {
        return this.target.getText();
    }

    @Override
    public int getStart() {
        return this.target.getStart();
    }

    @Override
    public int getStop() {
        return this.target.getStop();
    }

    @Override
    public int getLine() {
        return this.target.getLine();
    }

    @Override
    public int getCharPositionInLine() {
        return this.target.getCharPositionInLine();
    }

    public String toString() {
        return this.target.toString();
    }

    public Expression getTarget() {
        return this.target;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionParam)) {
            return false;
        }
        ExpressionParam other = (ExpressionParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$target = this.getTarget();
        Expression other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }
}

