/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang3.StringUtils;

public class GroupConcat
extends FunctionCall {
    private static final String SEPARATOR_KEY = "SEPARATOR";

    public GroupConcat(@NonNull ParserRuleContext context, @NonNull List<FunctionParam> functionParams) {
        super(context, "GROUP_CONCAT", functionParams);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
    }

    public GroupConcat(@NonNull List<FunctionParam> functionParams) {
        super("GROUP_CONCAT", functionParams);
        if (functionParams == null) {
            throw new NullPointerException("functionParams is marked non-null but is null");
        }
    }

    public String getSeparator() {
        return this.getOptions().stream().filter(s -> {
            if (!(s instanceof ConstExpression)) {
                return false;
            }
            ConstExpression c = (ConstExpression)s;
            return StringUtils.startsWithIgnoreCase((CharSequence)c.getExprConst(), (CharSequence)SEPARATOR_KEY);
        }).map(s -> {
            String c = ((ConstExpression)s).getExprConst();
            int begin = StringUtils.indexOfIgnoreCase((CharSequence)c, (CharSequence)SEPARATOR_KEY) + SEPARATOR_KEY.length();
            return c.substring(begin).trim();
        }).findFirst().orElse(null);
    }

    public OrderBy getOrderBy() {
        return this.getOptions().stream().filter(s -> s instanceof OrderBy).map(s -> (OrderBy)s).findFirst().orElse(null);
    }

    @Override
    public String doToString() {
        StringBuilder builder = new StringBuilder(this.getFunctionName());
        builder.append("(");
        if (this.getAggregator() != null) {
            builder.append(this.getAggregator()).append(" ");
        }
        builder.append(this.getParamList().stream().map(Object::toString).collect(Collectors.joining(",")));
        if (this.getOrderBy() != null) {
            builder.append(" ").append(this.getOrderBy().toString());
        }
        if (this.getSeparator() != null) {
            builder.append(" ").append(SEPARATOR_KEY).append(" ").append(this.getSeparator());
        }
        builder.append(")");
        if (this.getWindow() != null) {
            builder.append(" OVER ").append(this.getWindow().toString());
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupConcat)) {
            return false;
        }
        GroupConcat other = (GroupConcat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GroupConcat;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

