/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.expression;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class JsonOnOption
extends BaseStatement {
    private Expression onError;
    private Expression onEmpty;
    private List<OnMismatch> onMismatches;
    private Expression onNull;

    public JsonOnOption(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public JsonOnOption(@NonNull ParserRuleContext begin, @NonNull ParserRuleContext end) {
        super(begin, end);
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.onError != null) {
            builder.append(" ").append(this.onError).append(" ON ERROR_P");
        }
        if (this.onEmpty != null) {
            builder.append(" ").append(this.onEmpty).append(" ON EMPTY");
        }
        if (CollectionUtils.isNotEmpty(this.onMismatches)) {
            builder.append(" ").append(this.onMismatches.stream().map(OnMismatch::toString).collect(Collectors.joining(" ")));
        }
        if (this.onNull != null) {
            builder.append(" ").append(this.onNull).append(" ON NULL");
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public Expression getOnError() {
        return this.onError;
    }

    public Expression getOnEmpty() {
        return this.onEmpty;
    }

    public List<OnMismatch> getOnMismatches() {
        return this.onMismatches;
    }

    public Expression getOnNull() {
        return this.onNull;
    }

    public void setOnError(Expression onError) {
        this.onError = onError;
    }

    public void setOnEmpty(Expression onEmpty) {
        this.onEmpty = onEmpty;
    }

    public void setOnMismatches(List<OnMismatch> onMismatches) {
        this.onMismatches = onMismatches;
    }

    public void setOnNull(Expression onNull) {
        this.onNull = onNull;
    }

    public JsonOnOption() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonOnOption)) {
            return false;
        }
        JsonOnOption other = (JsonOnOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$onError = this.getOnError();
        Expression other$onError = other.getOnError();
        if (this$onError == null ? other$onError != null : !this$onError.equals(other$onError)) {
            return false;
        }
        Expression this$onEmpty = this.getOnEmpty();
        Expression other$onEmpty = other.getOnEmpty();
        if (this$onEmpty == null ? other$onEmpty != null : !this$onEmpty.equals(other$onEmpty)) {
            return false;
        }
        List<OnMismatch> this$onMismatches = this.getOnMismatches();
        List<OnMismatch> other$onMismatches = other.getOnMismatches();
        if (this$onMismatches == null ? other$onMismatches != null : !((Object)this$onMismatches).equals(other$onMismatches)) {
            return false;
        }
        Expression this$onNull = this.getOnNull();
        Expression other$onNull = other.getOnNull();
        return !(this$onNull == null ? other$onNull != null : !this$onNull.equals(other$onNull));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonOnOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $onError = this.getOnError();
        result = result * 59 + ($onError == null ? 43 : $onError.hashCode());
        Expression $onEmpty = this.getOnEmpty();
        result = result * 59 + ($onEmpty == null ? 43 : $onEmpty.hashCode());
        List<OnMismatch> $onMismatches = this.getOnMismatches();
        result = result * 59 + ($onMismatches == null ? 43 : ((Object)$onMismatches).hashCode());
        Expression $onNull = this.getOnNull();
        result = result * 59 + ($onNull == null ? 43 : $onNull.hashCode());
        return result;
    }

    public static class OnMismatch
    extends BaseStatement {
        private final Expression opt;
        private final List<String> mismatchTypes;

        public OnMismatch(@NonNull ParserRuleContext context, @NonNull Expression opt, List<String> mismatchTypes) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            if (opt == null) {
                throw new NullPointerException("opt is marked non-null but is null");
            }
            this.opt = opt;
            this.mismatchTypes = mismatchTypes;
        }

        public OnMismatch(@NonNull Expression opt, List<String> mismatchTypes) {
            if (opt == null) {
                throw new NullPointerException("opt is marked non-null but is null");
            }
            this.opt = opt;
            this.mismatchTypes = mismatchTypes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.opt).append(" ON MISMATCH");
            if (CollectionUtils.isNotEmpty(this.mismatchTypes)) {
                builder.append(" (").append(String.join((CharSequence)",", this.mismatchTypes)).append(")");
            }
            return builder.toString();
        }

        public Expression getOpt() {
            return this.opt;
        }

        public List<String> getMismatchTypes() {
            return this.mismatchTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OnMismatch)) {
                return false;
            }
            OnMismatch other = (OnMismatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$opt = this.getOpt();
            Expression other$opt = other.getOpt();
            if (this$opt == null ? other$opt != null : !this$opt.equals(other$opt)) {
                return false;
            }
            List<String> this$mismatchTypes = this.getMismatchTypes();
            List<String> other$mismatchTypes = other.getMismatchTypes();
            return !(this$mismatchTypes == null ? other$mismatchTypes != null : !((Object)this$mismatchTypes).equals(other$mismatchTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OnMismatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $opt = this.getOpt();
            result = result * 59 + ($opt == null ? 43 : $opt.hashCode());
            List<String> $mismatchTypes = this.getMismatchTypes();
            result = result * 59 + ($mismatchTypes == null ? 43 : ((Object)$mismatchTypes).hashCode());
            return result;
        }
    }
}

