/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.insert;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.insert.mysql.SetColumn;
import com.oceanbase.tools.sqlparser.statement.select.PartitionUsage;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;

public class InsertTable
extends BaseStatement {
    private boolean nologging;
    private String alias;
    private PartitionUsage partitionUsage;
    private List<SetColumn> setColumns = Collections.emptyList();
    private List<ColumnReference> columns = Collections.emptyList();
    private List<List<Expression>> values = Collections.emptyList();
    private List<String> aliasColumns;
    private final SelectBody select;
    private final RelationFactor table;

    public InsertTable(@NonNull ParserRuleContext context, @NonNull RelationFactor table) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
        this.select = null;
    }

    public InsertTable(@NonNull ParserRuleContext context, @NonNull SelectBody select) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (select == null) {
            throw new NullPointerException("select is marked non-null but is null");
        }
        this.table = null;
        this.select = select;
    }

    public InsertTable(@NonNull TerminalNode begin, @NonNull ParserRuleContext end, @NonNull RelationFactor table) {
        super(begin, end);
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
        this.select = null;
    }

    public InsertTable(@NonNull TerminalNode begin, @NonNull ParserRuleContext end, @NonNull SelectBody select) {
        super(begin, end);
        if (begin == null) {
            throw new NullPointerException("begin is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (select == null) {
            throw new NullPointerException("select is marked non-null but is null");
        }
        this.table = null;
        this.select = select;
    }

    public InsertTable(@NonNull RelationFactor table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
        this.select = null;
    }

    public InsertTable(@NonNull SelectBody select) {
        if (select == null) {
            throw new NullPointerException("select is marked non-null but is null");
        }
        this.table = null;
        this.select = select;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("INTO");
        if (this.table != null) {
            builder.append(" ").append(this.table);
            if (this.partitionUsage != null) {
                builder.append(" ").append(this.partitionUsage);
            }
        } else if (this.select != null) {
            builder.append(" (").append(this.select).append(")");
        }
        if (this.alias != null && CollectionUtils.isEmpty(this.aliasColumns)) {
            builder.append(" ").append(this.alias);
        }
        if (this.nologging) {
            builder.append(" NOLOGGING");
        }
        if (CollectionUtils.isNotEmpty(this.columns)) {
            builder.append(" (").append(this.columns.stream().map(BaseExpression::toString).collect(Collectors.joining(","))).append(")");
        }
        if (CollectionUtils.isNotEmpty(this.values)) {
            if (this.values.size() == 1 && this.values.get(0).size() == 1) {
                Expression value = this.values.get(0).get(0);
                if (value instanceof Select || value instanceof SelectBody) {
                    builder.append(" ").append(value);
                } else {
                    builder.append(" VALUES ").append(value);
                }
            } else {
                builder.append(" VALUES ").append(this.values.stream().map(e -> "(" + e.stream().map(Object::toString).collect(Collectors.joining(",")) + ")").collect(Collectors.joining(",")));
            }
        } else if (CollectionUtils.isNotEmpty(this.setColumns)) {
            builder.append(" SET ").append(this.setColumns.stream().map(SetColumn::toString).collect(Collectors.joining(",")));
        }
        if (this.alias != null && CollectionUtils.isNotEmpty(this.aliasColumns)) {
            builder.append(" AS ").append(this.alias).append("(").append(String.join((CharSequence)",", this.aliasColumns)).append(")");
        }
        return builder.toString();
    }

    public boolean isNologging() {
        return this.nologging;
    }

    public String getAlias() {
        return this.alias;
    }

    public PartitionUsage getPartitionUsage() {
        return this.partitionUsage;
    }

    public List<SetColumn> getSetColumns() {
        return this.setColumns;
    }

    public List<ColumnReference> getColumns() {
        return this.columns;
    }

    public List<List<Expression>> getValues() {
        return this.values;
    }

    public List<String> getAliasColumns() {
        return this.aliasColumns;
    }

    public SelectBody getSelect() {
        return this.select;
    }

    public RelationFactor getTable() {
        return this.table;
    }

    public void setNologging(boolean nologging) {
        this.nologging = nologging;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPartitionUsage(PartitionUsage partitionUsage) {
        this.partitionUsage = partitionUsage;
    }

    public void setSetColumns(List<SetColumn> setColumns) {
        this.setColumns = setColumns;
    }

    public void setColumns(List<ColumnReference> columns) {
        this.columns = columns;
    }

    public void setValues(List<List<Expression>> values) {
        this.values = values;
    }

    public void setAliasColumns(List<String> aliasColumns) {
        this.aliasColumns = aliasColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertTable)) {
            return false;
        }
        InsertTable other = (InsertTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNologging() != other.isNologging()) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        PartitionUsage this$partitionUsage = this.getPartitionUsage();
        PartitionUsage other$partitionUsage = other.getPartitionUsage();
        if (this$partitionUsage == null ? other$partitionUsage != null : !((Object)this$partitionUsage).equals(other$partitionUsage)) {
            return false;
        }
        List<SetColumn> this$setColumns = this.getSetColumns();
        List<SetColumn> other$setColumns = other.getSetColumns();
        if (this$setColumns == null ? other$setColumns != null : !((Object)this$setColumns).equals(other$setColumns)) {
            return false;
        }
        List<ColumnReference> this$columns = this.getColumns();
        List<ColumnReference> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<List<Expression>> this$values = this.getValues();
        List<List<Expression>> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        List<String> this$aliasColumns = this.getAliasColumns();
        List<String> other$aliasColumns = other.getAliasColumns();
        if (this$aliasColumns == null ? other$aliasColumns != null : !((Object)this$aliasColumns).equals(other$aliasColumns)) {
            return false;
        }
        SelectBody this$select = this.getSelect();
        SelectBody other$select = other.getSelect();
        if (this$select == null ? other$select != null : !((Object)this$select).equals(other$select)) {
            return false;
        }
        RelationFactor this$table = this.getTable();
        RelationFactor other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InsertTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNologging() ? 79 : 97);
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        PartitionUsage $partitionUsage = this.getPartitionUsage();
        result = result * 59 + ($partitionUsage == null ? 43 : ((Object)$partitionUsage).hashCode());
        List<SetColumn> $setColumns = this.getSetColumns();
        result = result * 59 + ($setColumns == null ? 43 : ((Object)$setColumns).hashCode());
        List<ColumnReference> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<List<Expression>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        List<String> $aliasColumns = this.getAliasColumns();
        result = result * 59 + ($aliasColumns == null ? 43 : ((Object)$aliasColumns).hashCode());
        SelectBody $select = this.getSelect();
        result = result * 59 + ($select == null ? 43 : ((Object)$select).hashCode());
        RelationFactor $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }
}

