/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.JoinType;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.JoinCondition;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class JoinReference
extends BaseStatement
implements FromReference {
    private final FromReference left;
    private final FromReference right;
    private final JoinType type;
    private final JoinCondition condition;

    public JoinReference(@NonNull ParserRuleContext context, @NonNull FromReference left, @NonNull FromReference right, @NonNull JoinType type, JoinCondition condition) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.left = left;
        this.right = right;
        this.type = type;
        this.condition = condition;
    }

    public JoinReference(@NonNull FromReference left, @NonNull FromReference right, @NonNull JoinType type, JoinCondition condition) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.left = left;
        this.right = right;
        this.type = type;
        this.condition = condition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.left.toString()).append(" ").append(this.type.name().replace("_", " ")).append(" ").append(this.right.toString());
        if (this.condition == null) {
            return builder.toString();
        }
        return builder.append(" ").append(this.condition.toString()).toString();
    }

    public FromReference getLeft() {
        return this.left;
    }

    public FromReference getRight() {
        return this.right;
    }

    public JoinType getType() {
        return this.type;
    }

    public JoinCondition getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinReference)) {
            return false;
        }
        JoinReference other = (JoinReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FromReference this$left = this.getLeft();
        FromReference other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        FromReference this$right = this.getRight();
        FromReference other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        JoinType this$type = this.getType();
        JoinType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JoinCondition this$condition = this.getCondition();
        JoinCondition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !this$condition.equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FromReference $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        FromReference $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        JoinType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JoinCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        return result;
    }
}

