/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class OrderBy
extends BaseStatement {
    private final boolean siblings;
    private final List<SortKey> sortKeys;

    public OrderBy(@NonNull ParserRuleContext context, boolean siblings, @NonNull List<SortKey> sortKeys) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sortKeys == null) {
            throw new NullPointerException("sortKeys is marked non-null but is null");
        }
        this.siblings = siblings;
        this.sortKeys = sortKeys;
    }

    public OrderBy(@NonNull ParserRuleContext context, @NonNull List<SortKey> sortKeys) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (sortKeys == null) {
            throw new NullPointerException("sortKeys is marked non-null but is null");
        }
        this.siblings = false;
        this.sortKeys = sortKeys;
    }

    public OrderBy(@NonNull List<SortKey> sortKeys) {
        if (sortKeys == null) {
            throw new NullPointerException("sortKeys is marked non-null but is null");
        }
        this.siblings = false;
        this.sortKeys = sortKeys;
    }

    public OrderBy(boolean siblings, @NonNull List<SortKey> sortKeys) {
        if (sortKeys == null) {
            throw new NullPointerException("sortKeys is marked non-null but is null");
        }
        this.siblings = siblings;
        this.sortKeys = sortKeys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ORDER");
        if (this.siblings) {
            builder.append(" ").append("SIBLINGS");
        }
        builder.append(" BY ").append(this.sortKeys.stream().map(SortKey::toString).collect(Collectors.joining(",")));
        return builder.toString();
    }

    public boolean isSiblings() {
        return this.siblings;
    }

    public List<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSiblings() != other.isSiblings()) {
            return false;
        }
        List<SortKey> this$sortKeys = this.getSortKeys();
        List<SortKey> other$sortKeys = other.getSortKeys();
        return !(this$sortKeys == null ? other$sortKeys != null : !((Object)this$sortKeys).equals(other$sortKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderBy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSiblings() ? 79 : 97);
        List<SortKey> $sortKeys = this.getSortKeys();
        result = result * 59 + ($sortKeys == null ? 43 : ((Object)$sortKeys).hashCode());
        return result;
    }
}

