/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.select.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchAddition;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchDirection;
import com.oceanbase.tools.sqlparser.statement.select.oracle.FetchType;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class Fetch
extends BaseStatement {
    private final Expression fetch;
    private final Expression offset;
    private final FetchType type;
    private final FetchAddition addition;
    private final FetchDirection direction;

    public Fetch(@NonNull ParserRuleContext context, Expression fetch, FetchDirection direction, FetchType type, FetchAddition addition, Expression offset) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.type = type;
        this.addition = addition;
        this.fetch = fetch;
        this.direction = direction;
        this.offset = offset;
    }

    public Fetch(Expression fetch, FetchDirection direction, FetchType type, FetchAddition addition, Expression offset) {
        this.type = type;
        this.addition = addition;
        this.fetch = fetch;
        this.direction = direction;
        this.offset = offset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.offset != null) {
            builder.append("OFFSET ").append(this.offset.toString()).append(" ROWS ");
        }
        builder.append("FETCH");
        if (this.direction != null) {
            builder.append(" ").append(this.direction == FetchDirection.FIRST ? "FIRST" : "NEXT");
        }
        if (this.fetch != null) {
            builder.append(" ").append(this.fetch.toString());
        }
        if (this.type != null && this.type == FetchType.PERCENT) {
            builder.append(" ").append("PERCENT");
        }
        builder.append(" ROWS");
        if (this.addition != null) {
            builder.append(" ").append(this.addition == FetchAddition.ONLY ? "ONLY" : "WITH TIES");
        }
        return builder.toString();
    }

    public Expression getFetch() {
        return this.fetch;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public FetchType getType() {
        return this.type;
    }

    public FetchAddition getAddition() {
        return this.addition;
    }

    public FetchDirection getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fetch)) {
            return false;
        }
        Fetch other = (Fetch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$fetch = this.getFetch();
        Expression other$fetch = other.getFetch();
        if (this$fetch == null ? other$fetch != null : !this$fetch.equals(other$fetch)) {
            return false;
        }
        Expression this$offset = this.getOffset();
        Expression other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !this$offset.equals(other$offset)) {
            return false;
        }
        FetchType this$type = this.getType();
        FetchType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        FetchAddition this$addition = this.getAddition();
        FetchAddition other$addition = other.getAddition();
        if (this$addition == null ? other$addition != null : !((Object)((Object)this$addition)).equals((Object)other$addition)) {
            return false;
        }
        FetchDirection this$direction = this.getDirection();
        FetchDirection other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Fetch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $fetch = this.getFetch();
        result = result * 59 + ($fetch == null ? 43 : $fetch.hashCode());
        Expression $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        FetchType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        FetchAddition $addition = this.getAddition();
        result = result * 59 + ($addition == null ? 43 : ((Object)((Object)$addition)).hashCode());
        FetchDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        return result;
    }
}

