/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.Parameterizable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.ParametersInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticParametersInterceptor
extends AbstractInterceptor {
    private boolean parse;
    private boolean overwrite;
    static boolean devMode = false;
    private static final Logger LOG = LoggerFactory.getLogger(StaticParametersInterceptor.class);

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    public void setParse(String value) {
        this.parse = Boolean.valueOf(value);
    }

    public void setOverwrite(String value) {
        this.overwrite = Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        Object action = invocation.getAction();
        Map<String, String> parameters = config.getParams();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting static parameters " + parameters, new String[0]);
        }
        if (action instanceof Parameterizable) {
            ((Parameterizable)action).setParams(parameters);
        }
        if (parameters != null) {
            ActionContext ac = ActionContext.getContext();
            Map<String, Object> contextMap = ac.getContextMap();
            try {
                ReflectionContextState.setCreatingNullObjects(contextMap, true);
                ReflectionContextState.setReportingConversionErrors(contextMap, true);
                ValueStack stack = ac.getValueStack();
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    String val = entry.getValue();
                    if (this.parse && val instanceof String) {
                        val = TextParseUtil.translateVariables(val.toString(), stack);
                    }
                    try {
                        stack.setValue(entry.getKey(), val);
                    }
                    catch (RuntimeException e) {
                        if (!devMode) continue;
                        String developerNotification = LocalizedTextUtil.findText(ParametersInterceptor.class, "devmode.notification", ActionContext.getContext().getLocale(), "Developer Notification:\n{0}", new Object[]{"Unexpected Exception caught setting '" + entry.getKey() + "' on '" + action.getClass() + ": " + e.getMessage()});
                        LOG.error(developerNotification, new String[0]);
                        if (!(action instanceof ValidationAware)) continue;
                        ((ValidationAware)action).addActionMessage(developerNotification);
                    }
                }
                this.addParametersToContext(ac, parameters);
            }
            finally {
                ReflectionContextState.setCreatingNullObjects(contextMap, false);
                ReflectionContextState.setReportingConversionErrors(contextMap, false);
            }
        }
        return invocation.invoke();
    }

    protected Map<String, String> retrieveParameters(ActionContext ac) {
        ActionConfig config = ac.getActionInvocation().getProxy().getConfig();
        if (config != null) {
            return config.getParams();
        }
        return Collections.emptyMap();
    }

    protected void addParametersToContext(ActionContext ac, Map<String, ?> newParams) {
        TreeMap<Object, Object> combinedParams;
        Map<String, Object> previousParams = ac.getParameters();
        if (this.overwrite) {
            combinedParams = previousParams != null ? new TreeMap<String, Object>(previousParams) : new TreeMap();
            if (newParams != null) {
                combinedParams.putAll(newParams);
            }
        } else {
            combinedParams = newParams != null ? new TreeMap(newParams) : new TreeMap();
            if (previousParams != null) {
                combinedParams.putAll(previousParams);
            }
        }
        ac.setParameters(combinedParams);
    }
}

