/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.logging.configuration;

import com.paypal.sdk.logging.configuration.ApiRequestLoggingConfiguration;
import com.paypal.sdk.logging.configuration.ApiResponseLoggingConfiguration;
import com.paypal.sdk.logging.configuration.ReadonlyLoggingConfiguration;
import com.paypal.sdk.logging.configuration.ReadonlyRequestLoggingConfiguration;
import com.paypal.sdk.logging.configuration.ReadonlyResponseLoggingConfiguration;
import io.apimatic.core.logger.configurations.SdkLoggingConfiguration;
import io.apimatic.core.logger.configurations.SdkRequestLoggingConfiguration;
import io.apimatic.core.logger.configurations.SdkResponseLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.LoggingConfiguration;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class ApiLoggingConfiguration
implements ReadonlyLoggingConfiguration {
    private final LoggingConfiguration configuration;
    private final ApiRequestLoggingConfiguration requestLoggingConfiguration;
    private final ApiResponseLoggingConfiguration responseLoggingConfiguration;

    private ApiLoggingConfiguration(SdkLoggingConfiguration.Builder builder, ApiRequestLoggingConfiguration.Builder requestLoggingConfigurationBuilder, ApiResponseLoggingConfiguration.Builder responseLoggingConfigurationBuilder) {
        this.configuration = builder.build();
        this.requestLoggingConfiguration = requestLoggingConfigurationBuilder.build();
        this.responseLoggingConfiguration = responseLoggingConfigurationBuilder.build();
    }

    @Override
    public Logger getLogger() {
        if (this.configuration.getLogger() == null) {
            return null;
        }
        return this.configuration.getLogger().getLogger();
    }

    @Override
    public Level getLevel() {
        return this.configuration.getLevel();
    }

    @Override
    public boolean getMaskSensitiveHeaders() {
        return this.configuration.getMaskSensitiveHeaders();
    }

    @Override
    public ReadonlyRequestLoggingConfiguration getRequestConfig() {
        return this.requestLoggingConfiguration;
    }

    @Override
    public ReadonlyResponseLoggingConfiguration getResponseConfig() {
        return this.responseLoggingConfiguration;
    }

    public LoggingConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "ApiLoggingConfiguration [logger=" + this.getLogger() + " level=" + this.getLevel() + " maskSensitiveHeaders=" + this.getMaskSensitiveHeaders() + " requestLoggingConfiguration=" + this.getRequestConfig() + " responseLoggingConfiguration=" + this.getResponseConfig() + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder().logger(this.configuration.getLogger()).level(this.getLevel()).maskSensitiveHeaders(this.getMaskSensitiveHeaders());
        builder.apiRequestLoggingBuilder = ((ApiRequestLoggingConfiguration)this.getRequestConfig()).newBuilder();
        builder.apiResponseLoggingBuilder = ((ApiResponseLoggingConfiguration)this.getResponseConfig()).newBuilder();
        return builder;
    }

    public static class Builder {
        private final SdkLoggingConfiguration.Builder loggingBuilder = new SdkLoggingConfiguration.Builder();
        private ApiRequestLoggingConfiguration.Builder apiRequestLoggingBuilder = new ApiRequestLoggingConfiguration.Builder();
        private ApiResponseLoggingConfiguration.Builder apiResponseLoggingBuilder = new ApiResponseLoggingConfiguration.Builder();

        public Builder logger(Logger logger) {
            this.loggingBuilder.logger(logger);
            return this;
        }

        private Builder logger(io.apimatic.coreinterfaces.logger.Logger logger) {
            this.loggingBuilder.logger(logger);
            return this;
        }

        public Builder level(Level level) {
            this.loggingBuilder.level(level);
            return this;
        }

        public Builder maskSensitiveHeaders(boolean maskSensitiveHeaders) {
            this.loggingBuilder.maskSensitiveHeaders(maskSensitiveHeaders);
            return this;
        }

        public Builder requestConfig(Consumer<ApiRequestLoggingConfiguration.Builder> action) {
            if (action != null) {
                action.accept(this.apiRequestLoggingBuilder);
            }
            ApiRequestLoggingConfiguration obj = this.apiRequestLoggingBuilder.build();
            SdkRequestLoggingConfiguration.Builder requestConfigBuilder = (SdkRequestLoggingConfiguration.Builder)((SdkRequestLoggingConfiguration.Builder)((SdkRequestLoggingConfiguration.Builder)((SdkRequestLoggingConfiguration.Builder)((SdkRequestLoggingConfiguration.Builder)new SdkRequestLoggingConfiguration.Builder().body(obj.shouldLogBody())).headers(obj.shouldLogHeaders())).includeQueryInPath(obj.shouldIncludeQueryInPath()).excludeHeaders(obj.getHeadersToExclude().toArray(new String[0]))).includeHeaders(obj.getHeadersToInclude().toArray(new String[0]))).unmaskHeaders(obj.getHeadersToUnmask().toArray(new String[0]));
            this.loggingBuilder.requestConfig(requestConfigBuilder);
            return this;
        }

        public Builder responseConfig(Consumer<ApiResponseLoggingConfiguration.Builder> action) {
            if (action != null) {
                action.accept(this.apiResponseLoggingBuilder);
            }
            ApiResponseLoggingConfiguration obj = this.apiResponseLoggingBuilder.build();
            SdkResponseLoggingConfiguration.Builder responseConfigBuilder = (SdkResponseLoggingConfiguration.Builder)((SdkResponseLoggingConfiguration.Builder)((SdkResponseLoggingConfiguration.Builder)((SdkResponseLoggingConfiguration.Builder)((SdkResponseLoggingConfiguration.Builder)new SdkResponseLoggingConfiguration.Builder().body(obj.shouldLogBody())).headers(obj.shouldLogHeaders())).excludeHeaders(obj.getHeadersToExclude().toArray(new String[0]))).includeHeaders(obj.getHeadersToInclude().toArray(new String[0]))).unmaskHeaders(obj.getHeadersToUnmask().toArray(new String[0]));
            this.loggingBuilder.responseConfig(responseConfigBuilder);
            return this;
        }

        public Builder useDefaultLogger() {
            this.loggingBuilder.useDefaultLogger();
            return this;
        }

        public ApiLoggingConfiguration build() {
            return new ApiLoggingConfiguration(this.loggingBuilder, this.apiRequestLoggingBuilder, this.apiResponseLoggingBuilder);
        }
    }
}

