/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.LiabilityShiftIndicator;
import com.paypal.sdk.models.ThreeDSecureAuthenticationResponse;

public class AuthenticationResponse {
    private LiabilityShiftIndicator liabilityShift;
    private ThreeDSecureAuthenticationResponse threeDSecure;

    public AuthenticationResponse() {
    }

    public AuthenticationResponse(LiabilityShiftIndicator liabilityShift, ThreeDSecureAuthenticationResponse threeDSecure) {
        this.liabilityShift = liabilityShift;
        this.threeDSecure = threeDSecure;
    }

    @JsonGetter(value="liability_shift")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LiabilityShiftIndicator getLiabilityShift() {
        return this.liabilityShift;
    }

    @JsonSetter(value="liability_shift")
    public void setLiabilityShift(LiabilityShiftIndicator liabilityShift) {
        this.liabilityShift = liabilityShift;
    }

    @JsonGetter(value="three_d_secure")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ThreeDSecureAuthenticationResponse getThreeDSecure() {
        return this.threeDSecure;
    }

    @JsonSetter(value="three_d_secure")
    public void setThreeDSecure(ThreeDSecureAuthenticationResponse threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    public String toString() {
        return "AuthenticationResponse [liabilityShift=" + (Object)((Object)this.liabilityShift) + ", threeDSecure=" + this.threeDSecure + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().liabilityShift(this.getLiabilityShift()).threeDSecure(this.getThreeDSecure());
        return builder;
    }

    public static class Builder {
        private LiabilityShiftIndicator liabilityShift;
        private ThreeDSecureAuthenticationResponse threeDSecure;

        public Builder liabilityShift(LiabilityShiftIndicator liabilityShift) {
            this.liabilityShift = liabilityShift;
            return this;
        }

        public Builder threeDSecure(ThreeDSecureAuthenticationResponse threeDSecure) {
            this.threeDSecure = threeDSecure;
            return this;
        }

        public AuthenticationResponse build() {
            return new AuthenticationResponse(this.liabilityShift, this.threeDSecure);
        }
    }
}

