/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CaptureRequest;

public class CaptureAuthorizedPaymentInput {
    private String authorizationId;
    private String contentType;
    private String paypalMockResponse;
    private String paypalRequestId;
    private String prefer;
    private String paypalAuthAssertion;
    private CaptureRequest body;

    public CaptureAuthorizedPaymentInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public CaptureAuthorizedPaymentInput(String authorizationId, String contentType, String paypalMockResponse, String paypalRequestId, String prefer, String paypalAuthAssertion, CaptureRequest body) {
        this.authorizationId = authorizationId;
        this.contentType = contentType;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Mock-Response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return this.paypalMockResponse;
    }

    @JsonSetter(value="PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CaptureRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(CaptureRequest body) {
        this.body = body;
    }

    public String toString() {
        return "CaptureAuthorizedPaymentInput [authorizationId=" + this.authorizationId + ", contentType=" + this.contentType + ", paypalMockResponse=" + this.paypalMockResponse + ", paypalRequestId=" + this.paypalRequestId + ", prefer=" + this.prefer + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId, this.contentType).paypalMockResponse(this.getPaypalMockResponse()).paypalRequestId(this.getPaypalRequestId()).prefer(this.getPrefer()).paypalAuthAssertion(this.getPaypalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String contentType = "application/json";
        private String paypalMockResponse;
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalAuthAssertion;
        private CaptureRequest body;

        public Builder() {
        }

        public Builder(String authorizationId, String contentType) {
            this.authorizationId = authorizationId;
            this.contentType = contentType;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder body(CaptureRequest body) {
            this.body = body;
            return this;
        }

        public CaptureAuthorizedPaymentInput build() {
            return new CaptureAuthorizedPaymentInput(this.authorizationId, this.contentType, this.paypalMockResponse, this.paypalRequestId, this.prefer, this.paypalAuthAssertion, this.body);
        }
    }
}

