/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum CardBrand {
    VISA,
    MASTERCARD,
    DISCOVER,
    AMEX,
    SOLO,
    JCB,
    STAR,
    DELTA,
    SWITCH,
    MAESTRO,
    CB_NATIONALE,
    CONFIGOGA,
    CONFIDIS,
    ELECTRON,
    CETELEM,
    CHINA_UNION_PAY,
    DINERS,
    ELO,
    HIPER,
    HIPERCARD,
    RUPAY,
    GE,
    SYNCHRONY,
    EFTPOS,
    UNKNOWN,
    _UNKNOWN;

    private static TreeMap<String, CardBrand> valueMap;
    private String value;

    @JsonCreator
    public static CardBrand constructFromString(String toConvert) throws IOException {
        CardBrand enumValue = CardBrand.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static CardBrand fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<CardBrand> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (CardBrand enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        CardBrand.VISA.value = "VISA";
        CardBrand.MASTERCARD.value = "MASTERCARD";
        CardBrand.DISCOVER.value = "DISCOVER";
        CardBrand.AMEX.value = "AMEX";
        CardBrand.SOLO.value = "SOLO";
        CardBrand.JCB.value = "JCB";
        CardBrand.STAR.value = "STAR";
        CardBrand.DELTA.value = "DELTA";
        CardBrand.SWITCH.value = "SWITCH";
        CardBrand.MAESTRO.value = "MAESTRO";
        CardBrand.CB_NATIONALE.value = "CB_NATIONALE";
        CardBrand.CONFIGOGA.value = "CONFIGOGA";
        CardBrand.CONFIDIS.value = "CONFIDIS";
        CardBrand.ELECTRON.value = "ELECTRON";
        CardBrand.CETELEM.value = "CETELEM";
        CardBrand.CHINA_UNION_PAY.value = "CHINA_UNION_PAY";
        CardBrand.DINERS.value = "DINERS";
        CardBrand.ELO.value = "ELO";
        CardBrand.HIPER.value = "HIPER";
        CardBrand.HIPERCARD.value = "HIPERCARD";
        CardBrand.RUPAY.value = "RUPAY";
        CardBrand.GE.value = "GE";
        CardBrand.SYNCHRONY.value = "SYNCHRONY";
        CardBrand.EFTPOS.value = "EFTPOS";
        CardBrand.UNKNOWN.value = "UNKNOWN";
        CardBrand._UNKNOWN.value = null;
        valueMap.put("VISA", VISA);
        valueMap.put("MASTERCARD", MASTERCARD);
        valueMap.put("DISCOVER", DISCOVER);
        valueMap.put("AMEX", AMEX);
        valueMap.put("SOLO", SOLO);
        valueMap.put("JCB", JCB);
        valueMap.put("STAR", STAR);
        valueMap.put("DELTA", DELTA);
        valueMap.put("SWITCH", SWITCH);
        valueMap.put("MAESTRO", MAESTRO);
        valueMap.put("CB_NATIONALE", CB_NATIONALE);
        valueMap.put("CONFIGOGA", CONFIGOGA);
        valueMap.put("CONFIDIS", CONFIDIS);
        valueMap.put("ELECTRON", ELECTRON);
        valueMap.put("CETELEM", CETELEM);
        valueMap.put("CHINA_UNION_PAY", CHINA_UNION_PAY);
        valueMap.put("DINERS", DINERS);
        valueMap.put("ELO", ELO);
        valueMap.put("HIPER", HIPER);
        valueMap.put("HIPERCARD", HIPERCARD);
        valueMap.put("RUPAY", RUPAY);
        valueMap.put("GE", GE);
        valueMap.put("SYNCHRONY", SYNCHRONY);
        valueMap.put("EFTPOS", EFTPOS);
        valueMap.put("UNKNOWN", UNKNOWN);
    }
}

