/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.AuthorizationWithAdditionalData;
import com.paypal.sdk.models.OrdersCapture;
import com.paypal.sdk.models.Refund;
import java.util.List;

public class PaymentCollection {
    private List<AuthorizationWithAdditionalData> authorizations;
    private List<OrdersCapture> captures;
    private List<Refund> refunds;

    public PaymentCollection() {
    }

    public PaymentCollection(List<AuthorizationWithAdditionalData> authorizations, List<OrdersCapture> captures, List<Refund> refunds) {
        this.authorizations = authorizations;
        this.captures = captures;
        this.refunds = refunds;
    }

    @JsonGetter(value="authorizations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AuthorizationWithAdditionalData> getAuthorizations() {
        return this.authorizations;
    }

    @JsonSetter(value="authorizations")
    public void setAuthorizations(List<AuthorizationWithAdditionalData> authorizations) {
        this.authorizations = authorizations;
    }

    @JsonGetter(value="captures")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrdersCapture> getCaptures() {
        return this.captures;
    }

    @JsonSetter(value="captures")
    public void setCaptures(List<OrdersCapture> captures) {
        this.captures = captures;
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonSetter(value="refunds")
    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public String toString() {
        return "PaymentCollection [authorizations=" + this.authorizations + ", captures=" + this.captures + ", refunds=" + this.refunds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().authorizations(this.getAuthorizations()).captures(this.getCaptures()).refunds(this.getRefunds());
        return builder;
    }

    public static class Builder {
        private List<AuthorizationWithAdditionalData> authorizations;
        private List<OrdersCapture> captures;
        private List<Refund> refunds;

        public Builder authorizations(List<AuthorizationWithAdditionalData> authorizations) {
            this.authorizations = authorizations;
            return this;
        }

        public Builder captures(List<OrdersCapture> captures) {
            this.captures = captures;
            return this;
        }

        public Builder refunds(List<Refund> refunds) {
            this.refunds = refunds;
            return this;
        }

        public PaymentCollection build() {
            return new PaymentCollection(this.authorizations, this.captures, this.refunds);
        }
    }
}

