/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ExchangeRate;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.PlatformFee;
import java.util.List;

public class SellerReceivableBreakdown {
    private Money grossAmount;
    private Money paypalFee;
    private Money paypalFeeInReceivableCurrency;
    private Money netAmount;
    private Money receivableAmount;
    private ExchangeRate exchangeRate;
    private List<PlatformFee> platformFees;

    public SellerReceivableBreakdown() {
    }

    public SellerReceivableBreakdown(Money grossAmount, Money paypalFee, Money paypalFeeInReceivableCurrency, Money netAmount, Money receivableAmount, ExchangeRate exchangeRate, List<PlatformFee> platformFees) {
        this.grossAmount = grossAmount;
        this.paypalFee = paypalFee;
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
        this.netAmount = netAmount;
        this.receivableAmount = receivableAmount;
        this.exchangeRate = exchangeRate;
        this.platformFees = platformFees;
    }

    @JsonGetter(value="gross_amount")
    public Money getGrossAmount() {
        return this.grossAmount;
    }

    @JsonSetter(value="gross_amount")
    public void setGrossAmount(Money grossAmount) {
        this.grossAmount = grossAmount;
    }

    @JsonGetter(value="paypal_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPaypalFee() {
        return this.paypalFee;
    }

    @JsonSetter(value="paypal_fee")
    public void setPaypalFee(Money paypalFee) {
        this.paypalFee = paypalFee;
    }

    @JsonGetter(value="paypal_fee_in_receivable_currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPaypalFeeInReceivableCurrency() {
        return this.paypalFeeInReceivableCurrency;
    }

    @JsonSetter(value="paypal_fee_in_receivable_currency")
    public void setPaypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
        this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
    }

    @JsonGetter(value="net_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNetAmount() {
        return this.netAmount;
    }

    @JsonSetter(value="net_amount")
    public void setNetAmount(Money netAmount) {
        this.netAmount = netAmount;
    }

    @JsonGetter(value="receivable_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getReceivableAmount() {
        return this.receivableAmount;
    }

    @JsonSetter(value="receivable_amount")
    public void setReceivableAmount(Money receivableAmount) {
        this.receivableAmount = receivableAmount;
    }

    @JsonGetter(value="exchange_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExchangeRate getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonSetter(value="exchange_rate")
    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    @JsonGetter(value="platform_fees")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PlatformFee> getPlatformFees() {
        return this.platformFees;
    }

    @JsonSetter(value="platform_fees")
    public void setPlatformFees(List<PlatformFee> platformFees) {
        this.platformFees = platformFees;
    }

    public String toString() {
        return "SellerReceivableBreakdown [grossAmount=" + this.grossAmount + ", paypalFee=" + this.paypalFee + ", paypalFeeInReceivableCurrency=" + this.paypalFeeInReceivableCurrency + ", netAmount=" + this.netAmount + ", receivableAmount=" + this.receivableAmount + ", exchangeRate=" + this.exchangeRate + ", platformFees=" + this.platformFees + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.grossAmount).paypalFee(this.getPaypalFee()).paypalFeeInReceivableCurrency(this.getPaypalFeeInReceivableCurrency()).netAmount(this.getNetAmount()).receivableAmount(this.getReceivableAmount()).exchangeRate(this.getExchangeRate()).platformFees(this.getPlatformFees());
        return builder;
    }

    public static class Builder {
        private Money grossAmount;
        private Money paypalFee;
        private Money paypalFeeInReceivableCurrency;
        private Money netAmount;
        private Money receivableAmount;
        private ExchangeRate exchangeRate;
        private List<PlatformFee> platformFees;

        public Builder() {
        }

        public Builder(Money grossAmount) {
            this.grossAmount = grossAmount;
        }

        public Builder grossAmount(Money grossAmount) {
            this.grossAmount = grossAmount;
            return this;
        }

        public Builder paypalFee(Money paypalFee) {
            this.paypalFee = paypalFee;
            return this;
        }

        public Builder paypalFeeInReceivableCurrency(Money paypalFeeInReceivableCurrency) {
            this.paypalFeeInReceivableCurrency = paypalFeeInReceivableCurrency;
            return this;
        }

        public Builder netAmount(Money netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder receivableAmount(Money receivableAmount) {
            this.receivableAmount = receivableAmount;
            return this;
        }

        public Builder exchangeRate(ExchangeRate exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder platformFees(List<PlatformFee> platformFees) {
            this.platformFees = platformFees;
            return this;
        }

        public SellerReceivableBreakdown build() {
            return new SellerReceivableBreakdown(this.grossAmount, this.paypalFee, this.paypalFeeInReceivableCurrency, this.netAmount, this.receivableAmount, this.exchangeRate, this.platformFees);
        }
    }
}

