/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.transport.TransportEventHandler;
import com.peersafe.base.client.transport.WebSocketTransport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.json.JSONObject;

public class MockPair {
    public RippledMock server = new RippledMock();
    public MockClient client;

    public MockPair() {
        this.client = new MockClient(this.server.ws);
    }

    public MockPair connect(String url) {
        this.client.connect(url);
        this.client.scheduler.tick(50);
        this.server.connect();
        return this;
    }

    public static class RippledMock {
        public ArrayList<Message> messages;
        public ArrayList<Message> archived;
        MockSocket ws = new MockSocket();

        public RippledMock() {
            this.messages = new ArrayList();
            this.archived = new ArrayList();
        }

        public void connect() {
            if (this.ws.connected) {
                this.ws.onConnecting(0);
                this.ws.onConnected();
            }
        }

        public void disconnect() {
            if (this.ws.connected) {
                this.ws.onDisconnected(false);
            }
        }

        public void sendMessage(JSONObject json) {
            this.ws.onMessage(json);
        }

        public ArrayList<Message> unreadMarked() {
            ArrayList<Message> cleared = new ArrayList<Message>(this.messages);
            this.messages.clear();
            this.archived.addAll(cleared);
            return cleared;
        }

        public ArrayList<Message> unread() {
            return this.messages;
        }

        public Message popMessage() {
            if (this.messages.size() > 0) {
                Message popped = this.messages.remove(this.messages.size() - 1);
                this.archived.add(popped);
                return popped;
            }
            return null;
        }

        public void respond(Request request, String status, JSONObject result) {
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            response.put("id", request.id);
            response.put("status", (Object)status);
            response.put("type", (Object)"response");
            this.sendMessage(response);
        }

        public void respondSuccess(Request request, JSONObject result) {
            this.respond(request, "success", result);
        }

        public void respondSuccess(Request request, String result) {
            this.respondSuccess(request, Client.parseJSON(result));
        }

        class MockSocket
        implements WebSocketTransport,
        TransportEventHandler {
            TransportEventHandler handler;
            boolean connected;

            MockSocket() {
            }

            @Override
            public void setHandler(TransportEventHandler events2) {
                this.handler = events2;
            }

            @Override
            public void sendMessage(JSONObject msg) {
                RippledMock.this.messages.add(new Message(msg, true, RippledMock.this.messages.size()));
            }

            @Override
            public void connect(URI url) {
                this.connected = true;
            }

            @Override
            public void disconnect() {
                this.connected = false;
            }

            @Override
            public void onMessage(JSONObject msg) {
                this.handler.onMessage(msg);
            }

            @Override
            public void onConnecting(int attempt) {
                this.handler.onConnecting(attempt);
            }

            @Override
            public void onDisconnected(boolean willReconnect) {
                this.handler.onDisconnected(willReconnect);
            }

            @Override
            public void onError(Exception error) {
                this.handler.onError(error);
            }

            @Override
            public void onConnected() {
                this.handler.onConnected();
            }

            @Override
            public void connectSSL(URI url, String serverCertPath, String storePass) throws Exception {
            }
        }
    }

    public static class Message {
        JSONObject msg;
        boolean client;
        int n;

        public Message(JSONObject msg, boolean client, int n) {
            this.msg = msg;
            this.client = client;
            this.n = n;
        }

        public Request getRequest(Client c) {
            return c.requests.get(this.msg.optInt("id", -1));
        }
    }

    public class MockClient
    extends Client {
        public Scheduler scheduler;

        public MockClient(WebSocketTransport ws) {
            super(ws);
        }

        @Override
        protected void prepareExecutor() {
            this.service = null;
        }

        @Override
        public void run(Runnable runnable) {
            runnable.run();
        }

        @Override
        public void onMessage(JSONObject msg) {
            this.onMessageInClientThread(msg);
        }

        @Override
        public void schedule(long ms, Runnable runnable) {
            if (this.scheduler == null) {
                this.scheduler = new Scheduler();
            }
            this.scheduler.schedule(ms, runnable);
        }
    }

    public class Scheduler {
        private PriorityQueue<Callback> queue = new PriorityQueue();
        private int ms = 0;

        public void schedule(long delay, Runnable runnable) {
            this.queue.add(new Callback(runnable, delay));
        }

        public void tick(int pass) {
            this.ms += pass;
            Iterator<Callback> iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                Callback next = iterator.next();
                if (next.when > (long)this.ms) break;
                try {
                    next.runnable.run();
                }
                catch (Exception ignored) {
                    throw new RuntimeException(ignored);
                }
                finally {
                    iterator.remove();
                }
            }
        }

        public class Callback
        implements Comparable<Callback> {
            long when;
            Runnable runnable;

            public Callback(Runnable runnable, long delay) {
                this.when = (long)Scheduler.this.ms + delay;
                this.runnable = runnable;
            }

            @Override
            public int compareTo(Callback o) {
                if (this.when > o.when) {
                    return 1;
                }
                if (this.when == o.when) {
                    return 0;
                }
                return -1;
            }
        }
    }
}

