/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.blobvault;

import com.peersafe.base.crypto.sjcljson.JSONEncrypt;
import com.peersafe.base.encodings.common.B16;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

public class BlobVault {
    String baseUrl;
    public JSONEncrypt sjcl = new JSONEncrypt();

    public BlobVault(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public JSONObject getBlob(String user, String pass) throws IOException, InvalidCipherTextException {
        user = user.toLowerCase();
        String userPassUrl = this.userPassHash(user, pass);
        URL blobUrl = new URL(this.baseUrl + userPassUrl);
        HttpURLConnection getRequest = this.createGETRequestConnection(blobUrl);
        int responseCode = getRequest.getResponseCode();
        String data = this.readAllFromConnection(getRequest);
        if (responseCode == 404 || data.length() == 0) {
            throw new BlobNotFound("No blob found for user: " + user);
        }
        String utf8 = this.base64decodeUTF8(data);
        try {
            String decryptionKey = this.userPassDerivedDecryptionKey(user, pass);
            return this.sjcl.decrypt(decryptionKey, utf8);
        }
        catch (InvalidCipherTextException e) {
            String decryptionKey = this.userPassDerivedDecryptionKeyOLD(user, pass);
            return this.sjcl.decrypt(decryptionKey, utf8);
        }
    }

    private String userPassDerivedDecryptionKey(String user, String pass) {
        return user.length() + "|" + user + pass;
    }

    private String userPassDerivedDecryptionKeyOLD(String user, String pass) {
        return user + pass;
    }

    public String userPassHash(String user, String pass) {
        String toHash = user + pass;
        try {
            byte[] toHashBytes = toHash.getBytes("utf8");
            byte[] sha256 = MessageDigest.getInstance("SHA-256").digest(toHashBytes);
            return B16.toString(sha256);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpURLConnection createGETRequestConnection(URL website) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)website.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        return connection;
    }

    private String readAllFromConnection(HttpURLConnection connection) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder text = new StringBuilder();
        while ((line = buf.readLine()) != null) {
            text.append(line);
        }
        return text.toString();
    }

    private String base64decodeUTF8(String data) throws UnsupportedEncodingException {
        return new String(Base64.decode((String)data), "utf8");
    }

    public static class BlobNotFound
    extends RuntimeException {
        public BlobNotFound(String msg) {
            super(msg);
        }
    }
}

