/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.payments;

import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.PathSet;
import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;
import org.json.JSONObject;

public class Alternative
implements Comparable<Alternative> {
    public Amount sourceAmount;
    public PathSet paths;
    public Hash256 hash;

    public Alternative(PathSet paths, Amount sourceAmount) {
        this.paths = paths;
        this.sourceAmount = sourceAmount;
        this.hash = this.calculateHash(paths, sourceAmount);
    }

    private Hash256 calculateHash(PathSet paths, Amount sourceAmount) {
        HalfSha512 half = new HalfSha512();
        half.update(paths.toBytes());
        half.update(sourceAmount.toBytes());
        return half.finish();
    }

    @Override
    public int compareTo(Alternative another) {
        return this.hash.compareTo(another.hash);
    }

    public boolean directXRP() {
        return !this.hasPaths() && this.sourceAmount.isNative();
    }

    boolean hasPaths() {
        return this.paths.size() > 0;
    }

    public String toString() {
        JSONObject o = this.toJSON();
        return o.toString(2);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("source_amount", this.sourceAmount.toJSON());
        o.put("paths", this.paths.toJSON());
        return o;
    }
}

