/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.responses;

import com.peersafe.base.client.enums.RPCErr;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.serialized.enums.EngineResult;
import org.json.JSONObject;

public class Response {
    public JSONObject message;
    public Request request;
    public JSONObject result;
    public boolean succeeded;
    public String status;
    public RPCErr rpcerr;
    public String error;
    public String error_message;

    public Response(Request request, JSONObject message) {
        this.message = message;
        this.request = request;
        this.status = message.getString("status");
        this.succeeded = this.status.equals("success");
        if (this.succeeded) {
            this.result = message.getJSONObject("result");
            this.rpcerr = null;
        } else {
            try {
                this.error = message.getString("error");
                this.rpcerr = RPCErr.valueOf(this.error);
            }
            catch (Exception e) {
                this.rpcerr = RPCErr.unknownError;
            }
        }
    }

    public EngineResult engineResult() {
        return EngineResult.valueOf(this.result.getString("engine_result"));
    }

    public UInt32 getSubmitSequence() {
        return new UInt32(this.result.optJSONObject("tx_json").optInt("Sequence"));
    }
}

