/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions;

import com.peersafe.base.config.Config;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.RippleDate;
import com.peersafe.base.core.types.known.tx.Transaction;
import java.util.Date;
import org.json.JSONObject;

public class ServerInfo {
    public boolean updated = false;
    public int fee_base;
    public int fee_ref;
    public int drops_per_byte = (int)Math.ceil(976.5625);
    public int reserve_base;
    public int reserve_inc;
    public int load_base;
    public int load_factor;
    public long ledger_time;
    public long ledger_index;
    public int txn_success = 0;
    public int txn_failure = 0;
    public int txn_count;
    public String ledger_hash;
    public String random;
    public String server_status;
    public String validated_ledgers;

    public Amount computeFee(int units) {
        if (!this.updated) {
            throw new IllegalStateException("No information from the server yet");
        }
        if (this.fee_ref == 0) {
            this.fee_ref = 10;
        }
        if (this.load_base == 0) {
            this.load_base = 256;
        }
        if (this.fee_base == 0) {
            this.fee_base = 10;
        }
        if (this.load_factor == 0) {
            this.load_factor = 256;
        }
        double fee_unit = (double)this.fee_base / (double)this.fee_ref;
        double fee = (double)units * (fee_unit *= (double)this.load_factor / (double)this.load_base) * Config.getFeeCushion();
        String s = String.valueOf((long)Math.ceil(fee));
        return Amount.fromString(s);
    }

    public Amount transactionFee(Transaction transaction) {
        return this.computeFee(this.fee_base);
    }

    public void update(JSONObject json) {
        if (this.updated && json.optLong("ledger_index", this.ledger_index) < this.ledger_index) {
            return;
        }
        this.fee_base = json.optInt("fee_base", this.fee_base);
        this.drops_per_byte = json.optInt("drops_per_byte", this.drops_per_byte);
        this.txn_count = json.optInt("txn_count", this.txn_count);
        this.fee_ref = json.optInt("fee_ref", this.fee_ref);
        this.reserve_base = json.optInt("reserve_base", this.reserve_base);
        this.reserve_inc = json.optInt("reserve_inc", this.reserve_inc);
        this.load_base = json.optInt("load_base", this.load_base);
        this.load_factor = json.optInt("load_factor", this.load_factor);
        this.ledger_time = json.optLong("ledger_time", this.ledger_time);
        this.ledger_index = json.optLong("ledger_index", this.ledger_index);
        this.ledger_hash = json.optString("ledger_hash", this.ledger_hash);
        this.validated_ledgers = json.optString("validated_ledgers", this.validated_ledgers);
        this.random = json.optString("random", this.random);
        this.server_status = json.optString("server_status", this.server_status);
        this.txn_success = json.optInt("txn_success", this.txn_success);
        this.txn_failure = json.optInt("txn_failure", this.txn_failure);
        this.updated = true;
    }

    public Date date() {
        return RippleDate.fromSecondsSinceRippleEpoch(this.ledger_time);
    }

    public boolean primed() {
        return this.updated;
    }

    public void unprime() {
        this.updated = false;
    }
}

