/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions;

import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt32;
import java.util.logging.Logger;
import org.json.JSONObject;

public class TrackedAccountRoot
extends Publisher<events> {
    protected static final Logger logger = Logger.getLogger(TrackedAccountRoot.class.getName());
    boolean updated = false;
    public AccountID Account;
    private Amount Balance;
    public UInt32 Sequence;
    public UInt32 OwnerCount;
    public UInt32 Flags;
    public Hash256 PreviousTxnID;
    public UInt32 PreviousTxnLgrSeq;

    public boolean primed() {
        return this.updated;
    }

    public void updateFromTransaction(Hash256 transactionHash, UInt32 transactionLedgerIndex, STObject rootUpdates) {
        if (!this.updated || this.PreviousTxnID.equals(rootUpdates.get(Hash256.PreviousTxnID))) {
            this.setFromSTObject(rootUpdates.get(STObject.FinalFields));
            this.PreviousTxnID = transactionHash;
            this.PreviousTxnLgrSeq = transactionLedgerIndex;
        } else {
            logger.fine("hrmmm .... ");
        }
    }

    public Amount getBalance() {
        return this.Balance;
    }

    public void setBalance(Amount balance) {
        this.Balance = balance;
    }

    public TrackedAccountRoot(JSONObject object) {
        this.setFromJSON(object);
    }

    public TrackedAccountRoot(STObject object) {
        this.setFromSTObject(object);
    }

    public TrackedAccountRoot() {
    }

    public void setFromJSON(JSONObject jsonObject) {
        this.setFromSTObject(STObject.translate.fromJSONObject(jsonObject));
    }

    public void setUnfundedAccount(AccountID account) {
        this.Account = account;
        this.Balance = Amount.fromString("0");
        this.Sequence = new UInt32(1);
        this.OwnerCount = new UInt32(0);
        this.Flags = new UInt32(0);
        this.PreviousTxnID = new Hash256(new byte[32]);
        this.PreviousTxnLgrSeq = new UInt32(0);
        this.notifyUpdate();
    }

    public void setFromSTObject(STObject so) {
        if (so.has(AccountID.Account)) {
            this.Account = so.get(AccountID.Account);
        }
        if (so.has(Amount.Balance)) {
            this.Balance = so.get(Amount.Balance);
        }
        if (so.has(UInt32.Sequence)) {
            this.Sequence = so.get(UInt32.Sequence);
        }
        if (so.has(UInt32.OwnerCount)) {
            this.OwnerCount = so.get(UInt32.OwnerCount);
        }
        if (so.has(UInt32.Flags)) {
            this.Flags = so.get(UInt32.Flags);
        }
        if (so.has(Hash256.PreviousTxnID)) {
            this.PreviousTxnID = so.get(Hash256.PreviousTxnID);
        }
        if (so.has(UInt32.PreviousTxnLgrSeq)) {
            this.PreviousTxnLgrSeq = so.get(UInt32.PreviousTxnLgrSeq);
        }
        this.notifyUpdate();
    }

    private void notifyUpdate() {
        this.updated = true;
        this.emit(OnUpdate.class, this);
    }

    public static interface OnUpdate
    extends events<TrackedAccountRoot> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

