/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions.ledger;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.subscriptions.ledger.LedgerSubscriber;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import com.peersafe.base.core.types.shamap.TransactionTree;
import java.text.MessageFormat;

public class PendingLedger {
    private static final String logMessage = "({0}/{4}) {1}/{2} tx {3}";
    public Status status;
    TransactionTree transactions;
    int expectedTxns = -1;
    int clearedTransactions = 0;
    long ledger_index;
    private Client client;

    private Object[] logParameters() {
        return new Object[]{this.ledger_index, this.clearedTransactions, this.expectedTxns, this.transactions.hash(), this.status};
    }

    public void setStatus(Status status) {
        this.status = status;
        this.logStateChange();
    }

    public PendingLedger(long ledger_index, Client clientInstance) {
        this.ledger_index = ledger_index;
        this.transactions = new TransactionTree();
        this.client = clientInstance;
        this.status = Status.pending;
    }

    public void notifyTransaction(TransactionResult tr) {
        if (!this.transactions.hasLeaf(tr.hash)) {
            ++this.clearedTransactions;
            this.transactions.addTransactionResult(tr);
            this.client.onTransactionResult(tr);
            this.logStateChange();
        }
    }

    private void logStateChange() {
        LedgerSubscriber.log(logMessage, this.logParameters());
    }

    public String transactionHash() {
        return this.transactions.hash().toHex();
    }

    boolean transactionHashEquals(String transaction_hash) {
        return transaction_hash.equals(this.transactionHash());
    }

    public String toString() {
        Object[] arguments = this.logParameters();
        return MessageFormat.format("PendingLedger: ({0}/{4}) {1}/{2} tx {3}", arguments);
    }

    public static enum Status {
        pending,
        checkingHeader,
        fillingIn,
        cleared;

    }
}

