/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions.ledger;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.subscriptions.ledger.ClearedLedgersSet;
import com.peersafe.base.client.subscriptions.ledger.LedgerSubscriber;
import com.peersafe.base.client.subscriptions.ledger.PendingLedger;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class PendingLedgers {
    Client client;
    TreeMap<Long, PendingLedger> ledgers = new TreeMap();
    ClearedLedgersSet clearedLedgers = new ClearedLedgersSet();

    public PendingLedgers(Client clientInstance) {
        this.client = clientInstance;
    }

    public PendingLedger getOrAddLedger(long ledger_index) {
        PendingLedger ledger = this.ledgers.get(ledger_index);
        if (ledger == null) {
            ledger = this.constructAndAddLedger(ledger_index);
        }
        return ledger;
    }

    private PendingLedger constructAndAddLedger(long ledger_index) {
        if (this.clearedLedgers.contains(ledger_index)) {
            throw new AssertionError();
        }
        PendingLedger ledger = new PendingLedger(ledger_index, this.client);
        this.ledgers.put(ledger_index, ledger);
        return ledger;
    }

    public void clearLedger(long ledger_index, String from) {
        this.clearedLedgers.clear(ledger_index);
        PendingLedger remove = this.ledgers.remove(ledger_index);
        if (remove == null) {
            throw new AssertionError();
        }
        remove.setStatus(PendingLedger.Status.cleared);
        if (this.ledgers.size() == 1) {
            this.clearedLedgers.clearIfNoGaps();
        }
    }

    public void notifyTransactionResult(TransactionResult tr) {
        long key = tr.ledgerIndex.longValue();
        if (this.clearedLedgers.contains(key)) {
            System.out.println("warning");
            return;
        }
        PendingLedger ledger = this.getOrAddLedger(key);
        ledger.notifyTransaction(tr);
    }

    private void requestLedger(final long ledger_index, final boolean onlyHeader, final Publisher.Callback<Response> cb) {
        Request request = this.client.newRequest(Command.ledger);
        request.json("ledger_index", ledger_index);
        if (!onlyHeader) {
            request.json("transactions", true);
            request.json("expand", true);
        }
        request.once(Request.OnResponse.class, new Request.OnResponse(){

            @Override
            public void called(Response response) {
                if (response.succeeded) {
                    cb.called(response);
                } else {
                    System.out.println("PendingLedgers.called");
                    System.out.println(response.message);
                    PendingLedgers.this.client.schedule(1000L, new Runnable(){

                        @Override
                        public void run() {
                            PendingLedgers.this.requestLedger(ledger_index, onlyHeader, cb);
                        }
                    });
                }
            }
        });
        request.request();
    }

    void checkHeader(final PendingLedger ledger) {
        final long ledger_index = ledger.ledger_index;
        ledger.setStatus(PendingLedger.Status.checkingHeader);
        this.requestLedger(ledger_index, true, new Publisher.Callback<Response>(){

            @Override
            public void called(Response response) {
                JSONObject ledgerJSON = response.result.getJSONObject("ledger");
                String transaction_hash = ledgerJSON.getString("transaction_hash");
                boolean correctHash = ledger.transactionHashEquals(transaction_hash);
                if (correctHash) {
                    PendingLedgers.this.clearLedger(ledger_index, "checkHeader");
                } else {
                    LedgerSubscriber.log("Missing transactions, need to fillInLedger: " + ledger, new Object[0]);
                    PendingLedgers.this.fillInLedger(ledger);
                }
            }
        });
    }

    void fillInLedger(final PendingLedger ledger) {
        final long ledger_index = ledger.ledger_index;
        ledger.setStatus(PendingLedger.Status.fillingIn);
        this.requestLedger(ledger_index, false, new Publisher.Callback<Response>(){

            @Override
            public void called(Response response) {
                JSONObject ledgerJSON = response.result.getJSONObject("ledger");
                JSONArray transactions = ledgerJSON.getJSONArray("transactions");
                for (int i = 0; i < transactions.length(); ++i) {
                    JSONObject json = transactions.getJSONObject(i);
                    json.put("ledger_index", ledger_index);
                    json.put("validated", true);
                    TransactionResult tr = TransactionResult.fromJSON(json);
                    ledger.notifyTransaction(tr);
                }
                String transaction_hash = ledgerJSON.getString("transaction_hash");
                boolean correctHash = ledger.transactionHashEquals(transaction_hash);
                if (!correctHash) {
                    throw new IllegalStateException("We don't handle invalid transactions yet");
                }
                PendingLedgers.this.clearLedger(ledger_index, "fillInLedger");
            }
        });
    }

    public boolean alreadyPending(long j) {
        return this.ledgers.containsKey(j);
    }

    void trackMissingLedgersInClearedLedgerHistory() {
        for (Long j : this.clearedLedgers.gaps()) {
            if (this.alreadyPending(j)) continue;
            this.constructAndAddLedger(j);
        }
    }

    Set<Long> pendingLedgerIndexes() {
        return this.ledgers.keySet();
    }

    public void logPendingLedgers() {
        for (PendingLedger pendingLedger : this.ledgers.values()) {
            System.out.println(pendingLedger);
        }
    }
}

