/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.transactions;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.pubsub.CallbackContext;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.subscriptions.ServerInfo;
import com.peersafe.base.client.subscriptions.TrackedAccountRoot;
import com.peersafe.base.client.transactions.AccountTxPager;
import com.peersafe.base.client.transactions.ManagedTxn;
import com.peersafe.base.client.transactions.Submission;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.serialized.enums.EngineResult;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import com.peersafe.base.core.types.known.tx.txns.AccountSet;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.chainsql.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class TransactionManager
extends Publisher<events> {
    Client client;
    TrackedAccountRoot accountRoot;
    AccountID accountID;
    IKeyPair keyPair;
    AccountTxPager txnPager;
    public String message;
    private ArrayList<ManagedTxn> pending = new ArrayList();
    private ArrayList<ManagedTxn> failedTransactions = new ArrayList();
    Set<Long> seenValidatedSequences = new TreeSet<Long>();
    public long sequence = 0L;
    public static long LEDGERS_BETWEEN_ACCOUNT_TX = 15L;
    public static long ACCOUNT_TX_TIMEOUT = 5L;
    private long lastTxnRequesterUpdate = 0L;
    private long lastLedgerCheckedAccountTxns = 0L;
    AccountTxPager.OnPage onTxnsPage = new AccountTxPager.OnPage(){

        @Override
        public void onPage(AccountTxPager.Page page) {
            TransactionManager.this.lastTxnRequesterUpdate = TransactionManager.this.client.serverInfo.ledger_index;
            if (page.hasNext()) {
                page.requestNext();
            } else {
                TransactionManager.this.lastLedgerCheckedAccountTxns = Math.max(TransactionManager.this.lastLedgerCheckedAccountTxns, page.ledgerMax());
                TransactionManager.this.txnPager = null;
            }
            for (TransactionResult tr : page.transactionResults()) {
                TransactionManager.this.notifyTransactionResult(tr);
            }
        }
    };

    public TransactionManager(Client client, TrackedAccountRoot accountRoot, AccountID accountID, IKeyPair keyPair) {
        this.client = client;
        this.accountRoot = accountRoot;
        this.accountID = accountID;
        this.keyPair = keyPair;
        this.client.on(Client.OnLedgerClosed.class, new Client.OnLedgerClosed(){

            @Override
            public void called(ServerInfo serverInfo) {
                long ledgersClosed;
                TransactionManager.this.checkAccountTransactions(serverInfo.ledger_index);
                TransactionManager.this.clearFailed(serverInfo.ledger_index);
                if (!TransactionManager.this.canSubmit() || TransactionManager.this.getPending().isEmpty()) {
                    return;
                }
                ArrayList<ManagedTxn> sorted = TransactionManager.this.pendingSequenceSorted();
                ManagedTxn first = sorted.get(0);
                Submission previous = first.lastSubmission();
                if (previous != null && (ledgersClosed = serverInfo.ledger_index - previous.ledgerSequence) > 5L) {
                    TransactionManager.this.resubmitWithSameSequence(first);
                }
            }
        });
    }

    private void clearFailed(long ledger_index) {
        int safety = 1;
        for (ManagedTxn failed : this.failedTransactions) {
            Response response;
            int expired = 0;
            for (Submission submission : failed.submissions) {
                if (ledger_index - (long)safety <= submission.lastLedgerSequence.longValue()) continue;
                ++expired;
            }
            if (expired != failed.submissions.size() || (response = failed.lastSubmission().request.response) == null) continue;
            if (response.rpcerr != null) {
                failed.emit(ManagedTxn.OnSubmitError.class, response);
                continue;
            }
            failed.emit(ManagedTxn.OnSubmitFailure.class, response);
        }
    }

    private UInt32 locallyPreemptedSubmissionSequence() {
        if (!this.accountRoot.primed()) {
            throw new IllegalStateException("The AccountRoot hasn't been populated from the server");
        }
        long server = this.accountRoot.Sequence.longValue();
        if (server > this.sequence) {
            this.sequence = server;
        }
        return new UInt32(this.sequence++);
    }

    private boolean txnNotFinalizedAndSeenValidatedSequence(ManagedTxn txn) {
        return !txn.isFinalized() && this.seenValidatedSequences.contains(txn.sequence().longValue());
    }

    public Request submitSigned(final ManagedTxn txn) {
        Request req = this.client.newRequest(Command.submit);
        req.json("tx_blob", txn.tx_blob);
        req.json("ca_pem", txn.ca_pem);
        req.once(Request.OnSuccess.class, new Request.OnSuccess(){

            @Override
            public void called(Response response) {
                TransactionManager.this.handleSubmitSuccess(txn, response);
            }
        });
        req.once(Request.OnError.class, new Request.OnError(){

            @Override
            public void called(Response response) {
                TransactionManager.this.handleSubmitError(txn, response);
            }
        });
        txn.trackSubmitRequest(req, this.client.serverInfo.ledger_index);
        req.request();
        return req;
    }

    public void queue(final ManagedTxn tx) {
        if (this.accountRoot.primed()) {
            this.queue(tx, this.locallyPreemptedSubmissionSequence());
        } else {
            this.accountRoot.once(TrackedAccountRoot.OnUpdate.class, new TrackedAccountRoot.OnUpdate(){

                @Override
                public void called(TrackedAccountRoot accountRoot) {
                    TransactionManager.this.queue(tx, TransactionManager.this.locallyPreemptedSubmissionSequence());
                }
            });
        }
    }

    public ArrayList<ManagedTxn> getPending() {
        return this.pending;
    }

    public ArrayList<ManagedTxn> pendingSequenceSorted() {
        ArrayList<ManagedTxn> queued = new ArrayList<ManagedTxn>(this.getPending());
        Collections.sort(queued, new Comparator<ManagedTxn>(){

            @Override
            public int compare(ManagedTxn lhs, ManagedTxn rhs) {
                return lhs.sequence().compareTo(rhs.sequence());
            }
        });
        return queued;
    }

    public int txnsPending() {
        return this.getPending().size();
    }

    private void checkAccountTransactions(long currentLedgerIndex) {
        if (this.pending.size() == 0 && this.failedTransactions.size() == 0) {
            this.lastLedgerCheckedAccountTxns = 0L;
            return;
        }
        long ledgersPassed = currentLedgerIndex - this.lastLedgerCheckedAccountTxns;
        if (this.lastLedgerCheckedAccountTxns == 0L || ledgersPassed >= LEDGERS_BETWEEN_ACCOUNT_TX) {
            if (this.lastLedgerCheckedAccountTxns == 0L) {
                this.lastLedgerCheckedAccountTxns = currentLedgerIndex;
                for (ManagedTxn txn : this.pending) {
                    for (Submission submission : txn.submissions) {
                        this.lastLedgerCheckedAccountTxns = Math.min(this.lastLedgerCheckedAccountTxns, submission.ledgerSequence);
                    }
                }
                for (ManagedTxn txn : this.failedTransactions) {
                    for (Submission submission : txn.submissions) {
                        this.lastLedgerCheckedAccountTxns = Math.min(this.lastLedgerCheckedAccountTxns, submission.ledgerSequence);
                    }
                }
                return;
            }
            if (this.txnPager != null) {
                if (currentLedgerIndex - this.lastTxnRequesterUpdate >= ACCOUNT_TX_TIMEOUT) {
                    this.txnPager.abort();
                    this.txnPager = null;
                }
            } else {
                this.lastTxnRequesterUpdate = currentLedgerIndex;
                this.txnPager = new AccountTxPager(this.client, this.accountID, this.onTxnsPage, this.lastLedgerCheckedAccountTxns - 5L);
                this.txnPager.forward(true);
                this.txnPager.request();
            }
        }
    }

    private void queue(ManagedTxn txn, UInt32 sequence) {
        this.getPending().add(txn);
        this.makeSubmitRequest(txn, sequence);
    }

    public boolean canSubmit() {
        return this.client.connected && this.client.serverInfo.primed() && this.client.serverInfo.fee_base != 0 && this.client.serverInfo.load_factor < 768000 && this.accountRoot.primed();
    }

    private void makeSubmitRequest(final ManagedTxn txn, final UInt32 sequence) {
        if (this.canSubmit()) {
            this.doSubmitRequest(txn, sequence);
        } else {
            final int n = txn.submissions.size();
            this.client.on(Client.OnStateChange.class, new CallbackContext(){

                @Override
                public boolean shouldExecute() {
                    return TransactionManager.this.canSubmit() && !this.shouldRemove();
                }

                @Override
                public boolean shouldRemove() {
                    return txn.isFinalized() || n != txn.submissions.size();
                }
            }, new Client.OnStateChange(){

                @Override
                public void called(Client client) {
                    TransactionManager.this.doSubmitRequest(txn, sequence);
                }
            });
        }
    }

    private Request doSubmitRequest(ManagedTxn txn, UInt32 sequence) {
        Amount fee = this.client.serverInfo.transactionFee(txn.txn);
        int drops_per_byte = this.client.serverInfo.drops_per_byte;
        JSONObject txJson = new JSONObject(txn.txn.prettyJSON());
        Amount extraFee = Util.getExtraFee(txJson, drops_per_byte, TransactionType.valueOf(txJson.getString("TransactionType")));
        fee = fee.add(extraFee);
        long currentLedgerIndex = this.client.serverInfo.ledger_index;
        UInt32 lastLedgerSequence = new UInt32(currentLedgerIndex + 8L);
        Submission submission = txn.lastSubmission();
        if (submission != null && currentLedgerIndex - submission.lastLedgerSequence.longValue() < 8L) {
            lastLedgerSequence = submission.lastLedgerSequence;
        }
        txn.prepare(this.keyPair, fee, sequence, lastLedgerSequence);
        return this.submitSigned(txn);
    }

    public void handleSubmitError(final ManagedTxn txn, Response res) {
        if (txn.finalizedOrResponseIsToPriorSubmission(res)) {
            return;
        }
        switch (res.rpcerr) {
            case noNetwork: {
                this.client.schedule(500L, new Runnable(){

                    @Override
                    public void run() {
                        TransactionManager.this.resubmitWithSameSequence(txn);
                    }
                });
                break;
            }
            default: {
                txn.emit(ManagedTxn.OnSubmitError.class, res);
            }
        }
    }

    public void handleSubmitSuccess(ManagedTxn txn, Response res) {
        if (txn.finalizedOrResponseIsToPriorSubmission(res)) {
            return;
        }
        EngineResult ter = EngineResult.tesSUCCESS;
        try {
            ter = res.engineResult();
        }
        catch (Exception e) {
            ter = EngineResult.telNormalFailure;
        }
        switch (ter) {
            case tesSUCCESS: {
                txn.emit(ManagedTxn.OnSubmitSuccess.class, res);
                return;
            }
            case telNormalFailure: {
                txn.emit(ManagedTxn.OnSubmitError.class, res);
                return;
            }
        }
        txn.emit(ManagedTxn.OnSubmitError.class, res);
    }

    private void awaitLastLedgerSequenceExpiry(ManagedTxn txn) {
        this.finalizeTxnAndRemoveFromQueue(txn);
        this.failedTransactions.add(txn);
    }

    private void resubmitGreaterThan(UInt32 submitSequence) {
        for (ManagedTxn txn : this.getPending()) {
            if (txn.sequence().compareTo(submitSequence) != 1) continue;
            this.resubmitWithSameSequence(txn);
        }
    }

    private void queueSequencePlugTxn(UInt32 sequence) {
        ManagedTxn plug = this.manage(new AccountSet());
        plug.setSequencePlug(true);
        this.queue(plug, sequence);
    }

    public void finalizeTxnAndRemoveFromQueue(ManagedTxn transaction) {
        transaction.setFinalized();
        this.pending.remove(transaction);
    }

    private void resubmitFirstTransactionWithTakenSequence(UInt32 sequence) {
        for (ManagedTxn txn : this.getPending()) {
            if (txn.sequence().compareTo(sequence) != 0) continue;
            this.resubmitWithNewSequence(txn);
            break;
        }
    }

    private void resubmitWithNewSequence(final ManagedTxn txn) {
        if (txn.isSequencePlug()) {
            return;
        }
        if (this.txnNotFinalizedAndSeenValidatedSequence(txn)) {
            this.resubmit(txn, this.locallyPreemptedSubmissionSequence());
        } else {
            this.on(OnValidatedSequence.class, new CallbackContext(){

                @Override
                public boolean shouldExecute() {
                    return !txn.isFinalized();
                }

                @Override
                public boolean shouldRemove() {
                    return txn.isFinalized();
                }
            }, new OnValidatedSequence(){

                @Override
                public void called(UInt32 uInt32) {
                    if (TransactionManager.this.txnNotFinalizedAndSeenValidatedSequence(txn)) {
                        TransactionManager.this.resubmit(txn, TransactionManager.this.locallyPreemptedSubmissionSequence());
                    }
                }
            });
        }
    }

    private void resubmit(ManagedTxn txn, UInt32 sequence) {
    }

    private void resubmitWithSameSequence(ManagedTxn txn) {
        UInt32 previouslySubmitted = txn.sequence();
        this.resubmit(txn, previouslySubmitted);
    }

    public ManagedTxn manage(Transaction tt) {
        ManagedTxn txn = new ManagedTxn(tt);
        tt.account(this.accountID);
        return txn;
    }

    public void notifyTransactionResult(TransactionResult tr) {
        if (!tr.validated || !tr.initiatingAccount().equals(this.accountID)) {
            return;
        }
        UInt32 txnSequence = tr.txn.get(UInt32.Sequence);
        this.seenValidatedSequences.add(txnSequence.longValue());
        ManagedTxn txn = this.submittedTransactionForHash(tr.hash);
        if (txn != null) {
            this.finalizeTxnAndRemoveFromQueue(txn);
            this.failedTransactions.remove(txn);
            txn.emit(ManagedTxn.OnTransactionValidated.class, tr);
        } else {
            this.resubmitFirstTransactionWithTakenSequence(txnSequence);
            this.emit(OnValidatedSequence.class, txnSequence.add(new UInt32(1)));
        }
    }

    private ManagedTxn submittedTransactionForHash(Hash256 hash) {
        for (ManagedTxn pending : this.getPending()) {
            if (!pending.wasSubmittedWith(hash)) continue;
            return pending;
        }
        for (ManagedTxn markedAsFailed : this.failedTransactions) {
            if (!markedAsFailed.wasSubmittedWith(hash)) continue;
            return markedAsFailed;
        }
        return null;
    }

    public static interface OnValidatedSequence
    extends events<UInt32> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

