/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.config.Config;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.Issue;
import com.peersafe.base.core.coretypes.hash.Hash160;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.Index;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.fields.AccountIDField;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.fields.Type;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.serialized.TypeTranslator;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import com.peersafe.base.encodings.common.B16;
import java.util.HashMap;
import java.util.Map;

public class AccountID
extends Hash160 {
    public static Map<String, AccountID> aliases = new HashMap<String, AccountID>();
    public static AccountID NEUTRAL = AccountID.fromInteger(1);
    public static AccountID XRP_ISSUER = AccountID.fromInteger(0);
    public final String address;
    public static Translator translate = new Translator();
    public static AccountIDField Account = AccountID.accountField(Field.Account);
    public static AccountIDField Owner = AccountID.accountField(Field.Owner);
    public static AccountIDField Destination = AccountID.accountField(Field.Destination);
    public static AccountIDField Issuer = AccountID.accountField(Field.Issuer);
    public static AccountIDField Target = AccountID.accountField(Field.Target);
    public static AccountIDField RegularKey = AccountID.accountField(Field.RegularKey);
    public static AccountIDField User = AccountID.accountField(Field.User);
    public static AccountIDField OriginalAddress = AccountID.accountField(Field.OriginalAddress);
    public static AccountIDField ContractAddress = AccountID.accountField(Field.ContractAddress);

    public AccountID(byte[] bytes) {
        this(bytes, AccountID.encodeAddress(bytes));
    }

    public AccountID(byte[] bytes, String address) {
        super(bytes);
        this.address = address;
    }

    public static AccountID fromString(String value) {
        if (value.length() == 40) {
            return AccountID.fromAddressBytes(B16.decode(value));
        }
        if (value.startsWith("z") && value.length() >= 26) {
            return AccountID.fromAddress(value);
        }
        AccountID accountID = AccountID.accountForAlias(value);
        if (accountID == null) {
            throw new UnknownAlias("Alias unset: " + value);
        }
        return accountID;
    }

    public static AccountID fromAddress(String address) {
        byte[] bytes = Config.getB58IdentiferCodecs().decodeAddress(address);
        return new AccountID(bytes, address);
    }

    public static AccountID fromKeyPair(IKeyPair kp) {
        byte[] bytes = kp.pub160Hash();
        return new AccountID(bytes, AccountID.encodeAddress(bytes));
    }

    public static AccountID fromPassPhrase(String phrase) {
        return AccountID.fromKeyPair(Seed.fromPassPhrase(phrase).keyPair());
    }

    public static AccountID fromSeedString(String seed) {
        return AccountID.fromKeyPair(Seed.getKeyPair(seed));
    }

    public static AccountID fromSeedBytes(byte[] seed) {
        return AccountID.fromKeyPair(Seed.getKeyPair(seed));
    }

    public static AccountID fromInteger(Integer n) {
        return AccountID.fromBytes(new Hash160(new UInt32(n).toByteArray()).bytes());
    }

    public static AccountID fromBytes(byte[] bytes) {
        return new AccountID(bytes, AccountID.encodeAddress(bytes));
    }

    public static AccountID fromAddressBytes(byte[] bytes) {
        return AccountID.fromBytes(bytes);
    }

    @Override
    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public String toString() {
        return this.address;
    }

    public Issue issue(String code) {
        return new Issue(Currency.fromString(code), this);
    }

    public Issue issue(Currency c) {
        return new Issue(c, this);
    }

    public boolean isNativeIssuer() {
        return this.equals(XRP_ISSUER);
    }

    @Override
    public Object toJSON() {
        return this.toString();
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    @Override
    public void toBytesSink(BytesSink to) {
        to.add(this.bytes());
    }

    @Override
    public Type type() {
        return Type.AccountID;
    }

    public Hash256 lineIndex(Issue issue) {
        if (issue.isNative()) {
            throw new AssertionError();
        }
        return Index.rippleState(this, issue.issuer(), issue.currency());
    }

    private static String encodeAddress(byte[] a) {
        return Config.getB58IdentiferCodecs().encodeAddress(a);
    }

    public static AccountID addAliasFromPassPhrase(String n, String n2) {
        return aliases.put(n, AccountID.fromPassPhrase(n2));
    }

    public static AccountID accountForAlias(String value) {
        return aliases.get(value);
    }

    public static AccountIDField accountField(final Field f) {
        return new AccountIDField(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class UnknownAlias
    extends RuntimeException {
        private static final long serialVersionUID = -8042838677708510072L;

        public UnknownAlias(String s) {
            super(s);
        }
    }

    public static class Translator
    extends TypeTranslator<AccountID> {
        @Override
        public AccountID fromParser(BinaryParser parser, Integer hint) {
            if (hint == null) {
                hint = 20;
            }
            return AccountID.fromAddressBytes(parser.read(hint));
        }

        @Override
        public String toString(AccountID obj) {
            return obj.toString();
        }

        @Override
        public AccountID fromString(String value) {
            return AccountID.fromString(value);
        }
    }
}

