/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.serialized.BinaryParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class RippleDate
extends Date {
    public static long RIPPLE_EPOCH_SECONDS_OFFSET = 946684800L;

    private static void assertEquals(String s, String s1) {
        if (!s.equals(s1)) {
            throw new AssertionError((Object)String.format("%s != %s", s, s1));
        }
    }

    private static void assertEquals(long a, long b) {
        if (a != b) {
            throw new AssertionError((Object)String.format("%s != %s", a, b));
        }
    }

    private RippleDate() {
    }

    private RippleDate(long milliseconds) {
        super(milliseconds);
    }

    public long secondsSinceRippleEpoch() {
        return this.getTime() / 1000L - RIPPLE_EPOCH_SECONDS_OFFSET;
    }

    public static RippleDate fromSecondsSinceRippleEpoch(Number seconds) {
        return new RippleDate((seconds.longValue() + RIPPLE_EPOCH_SECONDS_OFFSET) * 1000L);
    }

    public static RippleDate fromParser(BinaryParser parser) {
        UInt32 uInt32 = UInt32.translate.fromParser(parser);
        return RippleDate.fromSecondsSinceRippleEpoch(uInt32);
    }

    public static RippleDate now() {
        return new RippleDate();
    }

    public static long localToUTC(String localTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date localDate = null;
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long localTimeInMillis = localDate.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        return calendar.getTimeInMillis();
    }

    public static String utcToLocal(long milliseconds) {
        SimpleDateFormat localFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(TimeZone.getDefault());
        localFormater.setTimeZone(TimeZone.getDefault());
        String localTime = localFormater.format(milliseconds);
        return localTime;
    }

    public static RippleDate iso8601ToChainsqlTime(String localTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date localDate = null;
        try {
            localDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new RippleDate(localDate.getTime());
    }

    public static long secondsSinceRippleEpoch(String localTime) {
        RippleDate date = RippleDate.iso8601ToChainsqlTime(localTime);
        return date.secondsSinceRippleEpoch();
    }

    public static String localFromSecondsSinceRippleEpoch(long secondsSinceRippleEpoch) {
        RippleDate date = RippleDate.fromSecondsSinceRippleEpoch(secondsSinceRippleEpoch);
        String localTime = RippleDate.utcToLocal(date.getTime());
        return localTime;
    }

    static {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.set(2000, 0, 1, 0, 0, 0);
        long computed = cal.getTimeInMillis() / 1000L;
        RippleDate.assertEquals("1 Jan 2000 00:00:00 GMT", cal.getTime().toGMTString());
        RippleDate.assertEquals(RIPPLE_EPOCH_SECONDS_OFFSET, computed);
    }
}

