/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Blob;
import com.peersafe.base.core.coretypes.PathSet;
import com.peersafe.base.core.coretypes.STArray;
import com.peersafe.base.core.coretypes.STObjectFormatter;
import com.peersafe.base.core.coretypes.Vector256;
import com.peersafe.base.core.coretypes.hash.Hash128;
import com.peersafe.base.core.coretypes.hash.Hash160;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt16;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.coretypes.uint.UInt8;
import com.peersafe.base.core.fields.AccountIDField;
import com.peersafe.base.core.fields.AmountField;
import com.peersafe.base.core.fields.BlobField;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.fields.HasField;
import com.peersafe.base.core.fields.Hash128Field;
import com.peersafe.base.core.fields.Hash160Field;
import com.peersafe.base.core.fields.Hash256Field;
import com.peersafe.base.core.fields.PathSetField;
import com.peersafe.base.core.fields.STArrayField;
import com.peersafe.base.core.fields.STObjectField;
import com.peersafe.base.core.fields.Type;
import com.peersafe.base.core.fields.UInt16Field;
import com.peersafe.base.core.fields.UInt32Field;
import com.peersafe.base.core.fields.UInt64Field;
import com.peersafe.base.core.fields.UInt8Field;
import com.peersafe.base.core.fields.Vector256Field;
import com.peersafe.base.core.formats.Format;
import com.peersafe.base.core.formats.LEFormat;
import com.peersafe.base.core.formats.TxFormat;
import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BinarySerializer;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.TypeTranslator;
import com.peersafe.base.core.serialized.enums.EngineResult;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import com.peersafe.base.core.serialized.enums.TransactionType;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.json.JSONObject;

public class STObject
implements SerializedType,
Iterable<Field> {
    protected FieldsMap fields;
    public Format format;
    public static Translator translate = new Translator();
    public static STObjectField TransactionMetaData = STObject.stobjectField(Field.TransactionMetaData);
    public static STObjectField CreatedNode = STObject.stobjectField(Field.CreatedNode);
    public static STObjectField DeletedNode = STObject.stobjectField(Field.DeletedNode);
    public static STObjectField ModifiedNode = STObject.stobjectField(Field.ModifiedNode);
    public static STObjectField PreviousFields = STObject.stobjectField(Field.PreviousFields);
    public static STObjectField FinalFields = STObject.stobjectField(Field.FinalFields);
    public static STObjectField NewFields = STObject.stobjectField(Field.NewFields);
    public static STObjectField TemplateEntry = STObject.stobjectField(Field.TemplateEntry);
    public static STObjectField Signer = STObject.stobjectField(Field.Signer);
    public static STObjectField SignerEntry = STObject.stobjectField(Field.SignerEntry);
    public static STObjectField Table = STObject.stobjectField(Field.Table);
    public static STObjectField WhiteList = STObject.stobjectField(Field.WhiteList);

    public STObject() {
        this.fields = new FieldsMap();
    }

    public STObject(FieldsMap fieldsMap) {
        this.fields = fieldsMap;
    }

    public static STObject fromJSON(String offerJson) {
        return STObject.fromJSONObject(new JSONObject(offerJson));
    }

    public static STObject fromJSONObject(JSONObject json) {
        return translate.fromJSONObject(json);
    }

    public static STObject fromHex(String hex) {
        return (STObject)translate.fromHex(hex);
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.keySet().iterator();
    }

    public String prettyJSON() {
        return translate.toJSONObject(this).toString(4);
    }

    public static STObject formatted(STObject source) {
        return STObjectFormatter.doFormatted(source);
    }

    public Format getFormat() {
        if (this.format == null) {
            this.computeFormat();
        }
        return this.format;
    }

    public void checkFormat() {
        Format fmt = this.getFormat();
        EnumMap<Field, Format.Requirement> requirements = fmt.requirements();
        for (Field field : this) {
            if (requirements.containsKey((Object)field)) continue;
            throw new FormatException(fmt.name() + " doesn't have field: " + (Object)((Object)field));
        }
        for (Field field : requirements.keySet()) {
            Format.Requirement req = requirements.get((Object)field);
            if (!this.has(field)) {
                if (req != Format.Requirement.REQUIRED) continue;
                throw new FormatException(fmt.name() + " requires " + (Object)((Object)field) + " of type " + (Object)((Object)field.getType()));
            }
            SerializedType type = this.get(field);
            if (type.type() == field.getType() || field.getType() == Type.Hash160 && type.type() == Type.AccountID) continue;
            throw new FormatException(type.toString() + " is not " + (Object)((Object)field.getType()));
        }
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    private void computeFormat() {
        UInt16 let;
        UInt16 tt = this.get(UInt16.TransactionType);
        if (tt != null) {
            this.setFormat(TxFormat.fromNumber(tt));
        }
        if ((let = this.get(UInt16.LedgerEntryType)) != null) {
            this.setFormat(LEFormat.fromNumber(let));
        }
    }

    public FieldsMap getFields() {
        return this.fields;
    }

    public SerializedType get(Field field) {
        return (SerializedType)this.fields.get((Object)field);
    }

    public static EngineResult engineResult(STObject obj) {
        return (EngineResult)obj.get(Field.TransactionResult);
    }

    public static LedgerEntryType ledgerEntryType(STObject obj) {
        return (LedgerEntryType)obj.get(Field.LedgerEntryType);
    }

    public static TransactionType transactionType(STObject obj) {
        return (TransactionType)obj.get(Field.TransactionType);
    }

    public SerializedType remove(Field f) {
        return (SerializedType)this.fields.remove((Object)f);
    }

    public boolean has(Field f) {
        return this.fields.containsKey((Object)f);
    }

    public <T extends HasField> boolean has(T hf) {
        return this.has(hf.getField());
    }

    public void put(UInt8Field f, UInt8 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(Vector256Field f, Vector256 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(BlobField f, Blob o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(UInt64Field f, UInt64 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(UInt32Field f, UInt32 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(UInt16Field f, UInt16 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(PathSetField f, PathSet o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(STObjectField f, STObject o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(Hash256Field f, Hash256 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(Hash160Field f, Hash160 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(Hash128Field f, Hash128 o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(STArrayField f, STArray o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(AmountField f, Amount o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public void put(AccountIDField f, AccountID o) {
        this.put(f.getField(), (SerializedType)o);
    }

    public <T extends HasField> void putTranslated(T f, Object value) {
        this.putTranslated(f.getField(), value);
    }

    public <T extends HasField> STObject as(T f, Object value) {
        this.putTranslated(f.getField(), value);
        return this;
    }

    public void put(Field f, SerializedType value) {
        this.fields.put(f, value);
    }

    public void putTranslated(Field f, Object value) {
        TypeTranslator<SerializedType> typeTranslator = Translators.forField(f);
        SerializedType st = null;
        try {
            st = typeTranslator.fromValue(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't put `" + value + "` into field `" + (Object)((Object)f) + "`\n" + e.toString());
        }
        this.fields.put(f, st);
    }

    public AccountID get(AccountIDField f) {
        return (AccountID)this.get(f.getField());
    }

    public Amount get(AmountField f) {
        return (Amount)this.get(f.getField());
    }

    public STArray get(STArrayField f) {
        return (STArray)this.get(f.getField());
    }

    public Hash128 get(Hash128Field f) {
        return (Hash128)this.get(f.getField());
    }

    public Hash160 get(Hash160Field f) {
        return (Hash160)this.get(f.getField());
    }

    public Hash256 get(Hash256Field f) {
        return (Hash256)this.get(f.getField());
    }

    public STObject get(STObjectField f) {
        return (STObject)this.get(f.getField());
    }

    public PathSet get(PathSetField f) {
        return (PathSet)this.get(f.getField());
    }

    public UInt16 get(UInt16Field f) {
        return (UInt16)this.get(f.getField());
    }

    public UInt32 get(UInt32Field f) {
        return (UInt32)this.get(f.getField());
    }

    public UInt64 get(UInt64Field f) {
        return (UInt64)this.get(f.getField());
    }

    public UInt8 get(UInt8Field f) {
        return (UInt8)this.get(f.getField());
    }

    public Vector256 get(Vector256Field f) {
        return (Vector256)this.get(f.getField());
    }

    public Blob get(BlobField f) {
        return (Blob)this.get(f.getField());
    }

    @Override
    public Object toJSON() {
        return translate.toJSON(this);
    }

    public JSONObject toJSONObject() {
        return translate.toJSONObject(this);
    }

    @Override
    public byte[] toBytes() {
        return translate.toBytes(this);
    }

    @Override
    public String toHex() {
        return translate.toHex(this);
    }

    public void toBytesSink(BytesSink to, FieldFilter p) {
        BinarySerializer serializer = new BinarySerializer(to);
        for (Field field : this) {
            if (!p.evaluate(field)) continue;
            SerializedType value = (SerializedType)this.fields.get((Object)field);
            serializer.add(field, value);
        }
    }

    @Override
    public void toBytesSink(BytesSink to) {
        this.toBytesSink(to, new FieldFilter(){

            @Override
            public boolean evaluate(Field field) {
                return field.isSerialized();
            }
        });
    }

    @Override
    public Type type() {
        return Type.STObject;
    }

    public int size() {
        return this.fields.size();
    }

    public static STObjectField stobjectField(final Field f) {
        return new STObjectField(){

            @Override
            public Field getField() {
                return f;
            }
        };
    }

    public static class Translators {
        private static TypeTranslator forType(Type type) {
            switch (type) {
                case STObject: {
                    return translate;
                }
                case Amount: {
                    return Amount.translate;
                }
                case UInt16: {
                    return UInt16.translate;
                }
                case UInt32: {
                    return UInt32.translate;
                }
                case UInt64: {
                    return UInt64.translate;
                }
                case Hash128: {
                    return Hash128.translate;
                }
                case Hash256: {
                    return Hash256.translate;
                }
                case Blob: {
                    return Blob.translate;
                }
                case AccountID: {
                    return AccountID.translate;
                }
                case STArray: {
                    return STArray.translate;
                }
                case UInt8: {
                    return UInt8.translate;
                }
                case Hash160: {
                    return Hash160.translate;
                }
                case PathSet: {
                    return PathSet.translate;
                }
                case Vector256: {
                    return Vector256.translate;
                }
            }
            throw new RuntimeException("Unknown type");
        }

        public static TypeTranslator<SerializedType> forField(Field field) {
            if (field.tag == null) {
                switch (field) {
                    case LedgerEntryType: {
                        field.tag = LedgerEntryType.translate;
                        break;
                    }
                    case TransactionType: {
                        field.tag = TransactionType.translate;
                        break;
                    }
                    case TransactionResult: {
                        field.tag = EngineResult.translate;
                        break;
                    }
                    default: {
                        field.tag = Translators.forType(field.getType());
                    }
                }
            }
            return Translators.getCastedTag(field);
        }

        private static TypeTranslator<SerializedType> getCastedTag(Field field) {
            return (TypeTranslator)field.tag;
        }
    }

    public static class Translator
    extends TypeTranslator<STObject> {
        @Override
        public STObject fromParser(BinaryParser parser, Integer hint) {
            Field field;
            STObject so = new STObject();
            if (hint != null) {
                hint = parser.pos() + hint;
            }
            while (!parser.end(hint) && (field = parser.readField()) != Field.ObjectEndMarker) {
                Integer sizeHint;
                TypeTranslator<SerializedType> tr = Translators.forField(field);
                SerializedType st = tr.fromParser(parser, sizeHint = field.isVLEncoded() ? Integer.valueOf(parser.readVLLength()) : null);
                if (st == null) {
                    throw new IllegalStateException("Parsed " + (Object)((Object)field) + " as null");
                }
                so.put(field, st);
            }
            return STObject.formatted(so);
        }

        @Override
        public Object toJSON(STObject obj) {
            return this.toJSONObject(obj);
        }

        @Override
        public JSONObject toJSONObject(STObject obj) {
            JSONObject json = new JSONObject();
            for (Field f : obj) {
                SerializedType obj1 = obj.get(f);
                Object object = obj1.toJSON();
                json.put(f.name(), object);
            }
            return json;
        }

        @Override
        public STObject fromJSONObject(JSONObject jsonObject) {
            STObject so = new STObject();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = jsonObject.get(key);
                Field fieldKey = Field.fromString(key);
                if (fieldKey == null) continue;
                so.putTranslated(fieldKey, value);
            }
            return STObject.formatted(so);
        }
    }

    public static class FormatException
    extends RuntimeException {
        public FormatException(String s) {
            super(s);
        }
    }

    public static interface FieldFilter {
        public boolean evaluate(Field var1);
    }

    public static class FieldsMap
    extends TreeMap<Field, SerializedType> {
    }
}

