/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes.hash;

import com.peersafe.base.core.serialized.BinaryParser;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.TypeTranslator;
import com.peersafe.base.encodings.common.B16;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class Hash<Subclass extends Hash>
implements SerializedType,
Comparable<Subclass> {
    protected final byte[] hash;
    protected int hashCode = -1;

    public Hash(byte[] bytes, int size) {
        this.hash = this.normalizeAndCheckHash(bytes, size);
    }

    public String toString() {
        return B16.toString(this.hash);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Arrays.hashCode(this.hash);
        }
        return this.hashCode;
    }

    private byte[] normalizeAndCheckHash(byte[] bytes, int size) {
        int length = bytes.length;
        if (length > size) {
            String simpleName = "";
            throw new RuntimeException("Hash length of " + length + "  is too wide for " + simpleName);
        }
        if (length == size) {
            return bytes;
        }
        byte[] hash = new byte[size];
        System.arraycopy(bytes, 0, hash, size - length, length);
        return hash;
    }

    BigInteger bigInteger() {
        return new BigInteger(1, this.hash);
    }

    public byte[] bytes() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hash) {
            return Arrays.equals(this.hash, ((Hash)obj).hash);
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(Subclass another) {
        byte[] thisBytes = this.bytes();
        byte[] bytes = ((Hash)another).bytes();
        return this.compareBytes(thisBytes, bytes, 0, thisBytes.length);
    }

    public int compareStartingAt(Subclass another, int start) {
        byte[] thisBytes = this.bytes();
        byte[] bytes = ((Hash)another).bytes();
        return this.compareBytes(thisBytes, bytes, start, thisBytes.length);
    }

    public int compareBytes(byte[] thisBytes, byte[] bytes, int start, int numBytes) {
        int thisLength = thisBytes.length;
        if (bytes.length != thisLength) {
            throw new RuntimeException();
        }
        for (int i = start; i < numBytes; ++i) {
            int cmp = (thisBytes[i] & 0xFF) - (bytes[i] & 0xFF);
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return 0;
    }

    public byte[] slice(int start) {
        return this.slice(start, 0);
    }

    public byte get(int i) {
        if (i < 0) {
            i += this.hash.length;
        }
        return this.hash[i];
    }

    public byte[] slice(int start, int end) {
        if (start < 0) {
            start += this.hash.length;
        }
        if (end <= 0) {
            end += this.hash.length;
        }
        int length = end - start;
        byte[] slice = new byte[length];
        System.arraycopy(this.hash, start, slice, 0, length);
        return slice;
    }

    public static abstract class HashTranslator<T extends Hash>
    extends TypeTranslator<T> {
        public abstract T newInstance(byte[] var1);

        public abstract int byteWidth();

        @Override
        public T fromParser(BinaryParser parser, Integer hint) {
            return this.newInstance(parser.read(this.byteWidth()));
        }

        @Override
        public Object toJSON(T obj) {
            return B16.toString(((Hash)obj).hash);
        }

        @Override
        public T fromString(String value) {
            return this.newInstance(B16.decode(value));
        }

        @Override
        public void toBytesSink(T obj, BytesSink to) {
            to.add(((Hash)obj).hash);
        }
    }
}

