/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.serialized;

import com.peersafe.base.core.fields.Field;
import com.peersafe.base.encodings.common.B16;

public class BinaryParser {
    protected final int size;
    protected byte[] bytes;
    protected int cursor = 0;

    public BinaryParser(byte[] bytes) {
        this.size = bytes.length;
        this.bytes = bytes;
    }

    public BinaryParser(int size) {
        this.size = size;
    }

    public BinaryParser(String hex) {
        this(B16.decode(hex));
    }

    public void skip(int n) {
        this.cursor += n;
    }

    public byte readOne() {
        return this.bytes[this.cursor++];
    }

    public byte[] read(int n) {
        byte[] ret = new byte[n];
        System.arraycopy(this.bytes, this.cursor, ret, 0, n);
        this.cursor += n;
        return ret;
    }

    public Field readField() {
        int fieldCode = this.readFieldCode();
        Field field = Field.fromCode(fieldCode);
        if (field == null) {
            throw new IllegalStateException("Couldn't parse field from " + Integer.toHexString(fieldCode));
        }
        return field;
    }

    public int readFieldCode() {
        int fieldBits;
        byte tagByte = this.readOne();
        int typeBits = (tagByte & 0xFF) >>> 4;
        if (typeBits == 0) {
            typeBits = this.readOne();
        }
        if ((fieldBits = tagByte & 0xF) == 0) {
            fieldBits = this.readOne();
        }
        return typeBits << 16 | fieldBits;
    }

    public boolean end() {
        return this.cursor >= this.size;
    }

    public int pos() {
        return this.cursor;
    }

    public int readOneInt() {
        return this.readOne() & 0xFF;
    }

    public int readVLLength() {
        int result;
        int b1 = this.readOneInt();
        if (b1 <= 192) {
            result = b1;
        } else if (b1 <= 240) {
            int b2 = this.readOneInt();
            result = 193 + (b1 - 193) * 256 + b2;
        } else if (b1 <= 254) {
            int b2 = this.readOneInt();
            int b3 = this.readOneInt();
            result = 12481 + (b1 - 241) * 65536 + b2 * 256 + b3;
        } else {
            throw new RuntimeException("Invalid varint length indicator");
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public boolean end(Integer customEnd) {
        return this.cursor >= this.size || customEnd != null && this.cursor >= customEnd;
    }
}

