/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.sle.entries;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.IssuePair;
import com.peersafe.base.core.coretypes.Quality;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.Vector256;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.Index;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import com.peersafe.base.core.types.known.sle.ThreadedLedgerEntry;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class Offer
extends ThreadedLedgerEntry {
    public static Comparator<Offer> qualityAscending = new Comparator<Offer>(){

        @Override
        public int compare(Offer lhs, Offer rhs) {
            return lhs.directoryAskQuality().compareTo(rhs.directoryAskQuality());
        }
    };

    public Offer() {
        super(LedgerEntryType.Offer);
    }

    public BigDecimal directoryAskQuality() {
        return Quality.fromBookDirectory(this.bookDirectory(), this.takerPays().isNative(), this.takerGets().isNative());
    }

    public BigDecimal askQuality() {
        return this.takerPays().computeQuality(this.takerGets());
    }

    public BigDecimal bidQuality() {
        return this.takerGets().computeQuality(this.takerPays());
    }

    public Amount getsOne() {
        return this.takerGets().one();
    }

    public Amount paysOne() {
        return this.takerPays().one();
    }

    public String getPayCurrencyPair() {
        return this.takerGets().currencyString() + "/" + this.takerPays().currencyString();
    }

    public STObject executed(STObject finalFields) {
        STObject executed = new STObject();
        executed.put(Amount.TakerPays, finalFields.get(Amount.TakerPays).subtract(this.takerPays()));
        executed.put(Amount.TakerGets, finalFields.get(Amount.TakerGets).subtract(this.takerGets()));
        return executed;
    }

    public Hash256 lineIndex(Amount amt) {
        return this.account().lineIndex(amt.issue());
    }

    public Hash256 fundingSource() {
        Amount takerGets = this.takerGets();
        if (this.account().equals(takerGets.issuer())) {
            return null;
        }
        if (takerGets.isNative()) {
            return Index.accountRoot(this.account());
        }
        return this.lineIndex(takerGets);
    }

    public Vector256 lineIndexes() {
        Vector256 ret = new Vector256();
        Amount takerGets = this.takerGets();
        for (Amount amt : new Amount[]{takerGets, this.takerPays()}) {
            if (amt == this.takerGets() || amt.isNative()) continue;
            ret.add(this.lineIndex(amt));
        }
        return ret;
    }

    public Hash256 bookBase() {
        return Index.bookStart(this.takerPays().issue(), this.takerGets().issue());
    }

    public boolean belongsToBook(Hash256 bookBase) {
        byte[] baseBytes = bookBase.bytes();
        byte[] directoryBytes = this.bookDirectory().bytes();
        for (int i = 0; i < 24; ++i) {
            if (baseBytes[i] == directoryBytes[i]) continue;
            return false;
        }
        return true;
    }

    public boolean sellingOwnFunds() {
        return this.account().equals(this.takerGets().issuer());
    }

    public Amount takerGetsFunded() {
        return this.has(Field.taker_gets_funded) ? this.get(Amount.taker_gets_funded) : this.takerGets();
    }

    public Amount takerPaysFunded() {
        return this.has(Field.taker_pays_funded) ? this.get(Amount.taker_pays_funded) : this.takerPays();
    }

    public static Iterator<Offer> iterateCollection(Collection<STObject> offers) {
        final Iterator<STObject> iterator = offers.iterator();
        return new Iterator<Offer>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Offer next() {
                return (Offer)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public Hash256 bookNodeDirectoryIndex() {
        return Index.directoryNode(this.bookDirectory(), this.bookNode());
    }

    public Hash256 ownerNodeDirectoryIndex() {
        Hash256 ownerDir = Index.ownerDirectory(this.account());
        return Index.directoryNode(ownerDir, this.ownerNode());
    }

    public UInt32 sequence() {
        return this.get(UInt32.Sequence);
    }

    public UInt32 expiration() {
        return this.get(UInt32.Expiration);
    }

    public UInt64 bookNode() {
        return this.get(UInt64.BookNode);
    }

    public UInt64 ownerNode() {
        return this.get(UInt64.OwnerNode);
    }

    public Hash256 bookDirectory() {
        return this.get(Hash256.BookDirectory);
    }

    public Amount takerPays() {
        return this.get(Amount.TakerPays);
    }

    public Amount takerGets() {
        return this.get(Amount.TakerGets);
    }

    public AccountID account() {
        return this.get(AccountID.Account);
    }

    public void sequence(UInt32 val) {
        this.put(Field.Sequence, (SerializedType)val);
    }

    public void expiration(UInt32 val) {
        this.put(Field.Expiration, (SerializedType)val);
    }

    public void bookNode(UInt64 val) {
        this.put(Field.BookNode, (SerializedType)val);
    }

    public void ownerNode(UInt64 val) {
        this.put(Field.OwnerNode, (SerializedType)val);
    }

    public void bookDirectory(Hash256 val) {
        this.put(Field.BookDirectory, (SerializedType)val);
    }

    public void takerPays(Amount val) {
        this.put(Field.TakerPays, (SerializedType)val);
    }

    public void takerGets(Amount val) {
        this.put(Field.TakerGets, (SerializedType)val);
    }

    public void account(AccountID val) {
        this.put(Field.Account, (SerializedType)val);
    }

    public Hash256[] directoryIndexes() {
        return new Hash256[]{this.bookNodeDirectoryIndex(), this.ownerNodeDirectoryIndex()};
    }

    public void setOfferDefaults() {
        if (this.bookNode() == null) {
            this.bookNode(UInt64.ZERO);
        }
        if (this.ownerNode() == null) {
            this.ownerNode(UInt64.ZERO);
        }
    }

    public IssuePair issuePair() {
        return new IssuePair(this.takerPays().issue(), this.takerGets().issue());
    }

    public Amount payToGet(Amount funded) {
        BigDecimal quality = this.directoryAskQuality();
        return this.paysOne().multiply(funded.multiply(quality));
    }
}

