/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.tx;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Blob;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.prefixes.HashPrefix;
import com.peersafe.base.core.coretypes.uint.UInt16;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.enums.TransactionFlag;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.formats.Format;
import com.peersafe.base.core.formats.TxFormat;
import com.peersafe.base.core.serialized.BytesList;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.signed.SignedTransaction;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.utils.HashUtils;
import java.util.EnumMap;
import org.json.JSONObject;

public class Transaction
extends STObject {
    public static final boolean CANONICAL_FLAG_DEPLOYED = true;
    public static final UInt32 CANONICAL_SIGNATURE = new UInt32(TransactionFlag.FullyCanonicalSig);

    public Transaction(TransactionType type) {
        this.setFormat(TxFormat.formats.get(type));
        this.put(Field.TransactionType, type);
    }

    public SignedTransaction sign(String secret) {
        SignedTransaction signed = SignedTransaction.fromTx(this);
        signed.sign(secret);
        return signed;
    }

    public SignedTransaction sign(IKeyPair keyPair) {
        SignedTransaction signed = SignedTransaction.fromTx(this);
        signed.sign(keyPair);
        return signed;
    }

    public SignedTransaction multiSign(String secret) {
        SignedTransaction signed = SignedTransaction.fromTx(this);
        signed.multiSign(secret);
        return signed;
    }

    public void parseFromJson(JSONObject obj) throws Exception {
        EnumMap<Field, Format.Requirement> fieldMap = this.format.requirements();
        for (Field field : fieldMap.keySet()) {
            String fieldName = field.name();
            if (!obj.has(fieldName)) continue;
            this.putTranslated(field, obj.get(fieldName));
        }
    }

    public TransactionType transactionType() {
        return Transaction.transactionType(this);
    }

    public Hash256 signingHash() {
        HalfSha512 signing = HalfSha512.prefixed256(HashPrefix.txSign);
        this.toBytesSink(signing, new STObject.FieldFilter(){

            @Override
            public boolean evaluate(Field a) {
                return a.isSigningField();
            }
        });
        return signing.finish();
    }

    public byte[] signingData() {
        BytesList bl = new BytesList();
        bl.add(HashPrefix.txSign.bytes);
        this.toBytesSink(bl, new STObject.FieldFilter(){

            @Override
            public boolean evaluate(Field a) {
                return a.isSigningField();
            }
        });
        return bl.bytes();
    }

    public byte[] multiSigningData(AccountID account) {
        BytesList bl = new BytesList();
        bl.add(HashPrefix.txMultiSign.bytes);
        this.toBytesSink(bl, new STObject.FieldFilter(){

            @Override
            public boolean evaluate(Field a) {
                return a.isSigningField();
            }
        });
        bl.add(account.toBytes());
        return bl.bytes();
    }

    public void setCanonicalSignatureFlag() {
        UInt32 flags = this.get(UInt32.Flags);
        flags = flags == null ? CANONICAL_SIGNATURE : (UInt32)flags.or(CANONICAL_SIGNATURE);
        this.put(UInt32.Flags, flags);
    }

    public UInt32 flags() {
        return this.get(UInt32.Flags);
    }

    public UInt32 sourceTag() {
        return this.get(UInt32.SourceTag);
    }

    public UInt32 sequence() {
        return this.get(UInt32.Sequence);
    }

    public UInt32 lastLedgerSequence() {
        return this.get(UInt32.LastLedgerSequence);
    }

    public UInt32 operationLimit() {
        return this.get(UInt32.OperationLimit);
    }

    public Hash256 previousTxnID() {
        return this.get(Hash256.PreviousTxnID);
    }

    public Hash256 accountTxnID() {
        return this.get(Hash256.AccountTxnID);
    }

    public Amount fee() {
        return this.get(Amount.Fee);
    }

    public Blob signingPubKey() {
        return this.get(Blob.SigningPubKey);
    }

    public Blob txnSignature() {
        return this.get(Blob.TxnSignature);
    }

    public Blob autoFillField() {
        return this.get(Blob.AutoFillField);
    }

    public Blob statements() {
        return this.get(Blob.Statements);
    }

    public AccountID account() {
        return this.get(AccountID.Account);
    }

    public void transactionType(UInt16 val) {
        this.put(Field.TransactionType, (SerializedType)val);
    }

    public void flags(UInt32 val) {
        this.put(Field.Flags, (SerializedType)val);
    }

    public void sourceTag(UInt32 val) {
        this.put(Field.SourceTag, (SerializedType)val);
    }

    public void sequence(UInt32 val) {
        this.put(Field.Sequence, (SerializedType)val);
    }

    public void lastLedgerSequence(UInt32 val) {
        this.put(Field.LastLedgerSequence, (SerializedType)val);
    }

    public void operationLimit(UInt32 val) {
        this.put(Field.OperationLimit, (SerializedType)val);
    }

    public void previousTxnID(Hash256 val) {
        this.put(Field.PreviousTxnID, (SerializedType)val);
    }

    public void accountTxnID(Hash256 val) {
        this.put(Field.AccountTxnID, (SerializedType)val);
    }

    public void fee(Amount val) {
        this.put(Field.Fee, (SerializedType)val);
    }

    public void signingPubKey(Blob val) {
        this.put(Field.SigningPubKey, (SerializedType)val);
    }

    public void txnSignature(Blob val) {
        this.put(Field.TxnSignature, (SerializedType)val);
    }

    public void account(AccountID val) {
        this.put(Field.Account, (SerializedType)val);
    }

    public void autoFillField(Blob val) {
        this.put(Field.AutoFillField, (SerializedType)val);
    }

    public void statements(Blob val) {
        this.put(Field.Statements, (SerializedType)val);
    }

    public Hash256 hash() {
        return this.get(Hash256.hash);
    }

    public AccountID signingKey() {
        byte[] pubKey = HashUtils.SHA256_RIPEMD160(this.signingPubKey().toBytes());
        return AccountID.fromAddressBytes(pubKey);
    }
}

