/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.shamap;

import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.prefixes.Prefix;
import com.peersafe.base.core.serialized.BytesSink;
import com.peersafe.base.core.types.shamap.LeafWalker;
import com.peersafe.base.core.types.shamap.ShaMapInner;
import com.peersafe.base.core.types.shamap.ShaMapLeaf;

public abstract class ShaMapNode {
    protected Hash256 hash;

    public abstract boolean isLeaf();

    public abstract boolean isInner();

    public ShaMapLeaf asLeaf() {
        return (ShaMapLeaf)this;
    }

    public ShaMapInner asInner() {
        return (ShaMapInner)this;
    }

    abstract Prefix hashPrefix();

    public abstract void toBytesSink(BytesSink var1);

    public void invalidate() {
        this.hash = null;
    }

    public Hash256 hash() {
        if (this.hash == null) {
            this.hash = this.createHash();
        }
        return this.hash;
    }

    public Hash256 createHash() {
        HalfSha512 half = HalfSha512.prefixed256(this.hashPrefix());
        this.toBytesSink(half);
        return half.finish();
    }

    public void walkAnyLeaves(LeafWalker leafWalker) {
        if (this.isLeaf()) {
            leafWalker.onLeaf(this.asLeaf());
        } else {
            this.asInner().walkLeaves(leafWalker);
        }
    }
}

