/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.ecdsa;

import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.encodings.common.B16;
import com.peersafe.base.utils.HashUtils;
import com.peersafe.base.utils.Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EDKeyPair
implements IKeyPair {
    public final EdDSAPrivateKeySpec keySpec;
    public static final EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");

    public EDKeyPair(EdDSAPrivateKeySpec keySpec) {
        this.keySpec = keySpec;
    }

    @Override
    public String type() {
        return "ed25519";
    }

    public static EDKeyPair from256Seed(byte[] seedBytes) {
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(seedBytes, (EdDSAParameterSpec)ed25519);
        return new EDKeyPair(keySpec);
    }

    public static EDKeyPair from128Seed(byte[] seedBytes) {
        assert (seedBytes.length == 16);
        return EDKeyPair.from256Seed(HashUtils.halfSha512(seedBytes));
    }

    @Override
    public String canonicalPubHex() {
        return B16.toString(this.canonicalPubBytes());
    }

    @Override
    public BigInteger pub() {
        return Utils.uBigInt(this.pubBytes_());
    }

    private byte[] pubBytes_() {
        return this.keySpec.getA().toByteArray();
    }

    @Override
    public String privHex() {
        return B16.toString(this.keySpec.geta());
    }

    @Override
    public BigInteger priv() {
        return Utils.uBigInt(this.keySpec.geta());
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] sigBytes) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            sgr.initVerify((PublicKey)new EdDSAPublicKey(new EdDSAPublicKeySpec(this.keySpec.getA(), (EdDSAParameterSpec)ed25519)));
            sgr.update(message);
            return sgr.verify(sigBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] signMessage(byte[] message) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            EdDSAPrivateKey sKey = new EdDSAPrivateKey(this.keySpec);
            sgr.initSign((PrivateKey)sKey);
            sgr.update(message);
            return sgr.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] canonicalPubBytes() {
        byte[] pub = new byte[33];
        pub[0] = -19;
        System.arraycopy(this.pubBytes_(), 0, pub, 1, 32);
        return pub;
    }

    @Override
    public byte[] pub160Hash() {
        return HashUtils.SHA256_RIPEMD160(this.canonicalPubBytes());
    }
}

