/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.ecdsa;

import com.peersafe.base.config.Config;
import com.peersafe.base.crypto.ecdsa.EDKeyPair;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.K256KeyPair;
import com.peersafe.base.crypto.sm.SMKeyPair;
import com.peersafe.base.encodings.base58.B58;
import com.peersafe.base.utils.Sha512;
import com.peersafe.base.utils.Utils;
import com.peersafe.chainsql.util.Util;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Seed {
    public static byte[] VER_K256 = new byte[]{33};
    public static byte[] VER_ED25519 = new byte[]{1, -31, 75};
    public static byte[] VER_SM = new byte[]{2, -30, 76};
    public static byte[] VER_SOFT_SM = new byte[]{1, -30, 76};
    final byte[] seedBytes;
    byte[] version;

    public Seed(byte[] seedBytes) {
        this(VER_K256, seedBytes);
    }

    public Seed(byte[] version, byte[] seedBytes) {
        this.seedBytes = seedBytes;
        this.version = version;
    }

    public String toString() {
        return Config.getB58().encodeToStringChecked(this.seedBytes, this.version);
    }

    public byte[] bytes() {
        return this.seedBytes;
    }

    public byte[] version() {
        return this.version;
    }

    public Seed setEd25519() {
        this.version = VER_ED25519;
        return this;
    }

    public Seed setGM() {
        this.version = VER_SM;
        return this;
    }

    public IKeyPair keyPair() {
        return this.keyPair(0);
    }

    public IKeyPair rootKeyPair() {
        return this.keyPair(-1);
    }

    public IKeyPair keyPair(int account) {
        if (Arrays.equals(this.version, VER_ED25519)) {
            if (account != 0) {
                throw new AssertionError();
            }
            return EDKeyPair.from128Seed(this.seedBytes);
        }
        if (Arrays.equals(this.version, VER_SM)) {
            try {
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (Arrays.equals(this.version, VER_SOFT_SM)) {
            if (account != 0) {
                throw new AssertionError();
            }
            if (this.seedBytes.length == 32) {
                return SMKeyPair.from256Seed(this.seedBytes);
            }
            return SMKeyPair.generateKeyPair();
        }
        return Seed.createKeyPair(this.seedBytes, account);
    }

    public static Seed fromBase58(String b58) {
        String regEx = "^[a-zA-Z1-9]{51,51}";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(b58);
        if (Config.isUseGM()) {
            Seed seed = Seed.randomSeed();
            seed.setGM();
            return seed;
        }
        if (matcher.matches()) {
            byte[] secretBytes = Config.getB58IdentiferCodecs().decodeAccountPrivate(b58);
            return new Seed(VER_SOFT_SM, secretBytes);
        }
        B58.Decoded decoded = Config.getB58().decodeMulti(b58, 16, VER_K256, VER_ED25519);
        return new Seed(decoded.version, decoded.payload);
    }

    public static Seed fromPassPhrase(String passPhrase) {
        return new Seed(Seed.passPhraseToSeedBytes(passPhrase));
    }

    public static byte[] passPhraseToSeedBytes(String phrase) {
        try {
            return new Sha512(phrase.getBytes("utf-8")).finish128();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static IKeyPair createKeyPair(byte[] seedBytes) {
        return Seed.createKeyPair(seedBytes, 0);
    }

    public static IKeyPair createKeyPair(byte[] seedBytes, int accountNumber) {
        BigInteger privateGen = K256KeyPair.computePrivateGen(seedBytes);
        byte[] publicGenBytes = K256KeyPair.computePublicGenerator(privateGen);
        if (accountNumber == -1) {
            return new K256KeyPair(privateGen, Utils.uBigInt(publicGenBytes));
        }
        BigInteger secret = K256KeyPair.computeSecretKey(privateGen, publicGenBytes, accountNumber);
        BigInteger pub = K256KeyPair.computePublicKey(secret);
        return new K256KeyPair(secret, pub);
    }

    public static IKeyPair getKeyPair(byte[] seedBytes) {
        return Seed.createKeyPair(seedBytes, 0);
    }

    public static IKeyPair getKeyPair(String b58) {
        String regEx = "^[a-zA-Z1-9]{51,51}";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(b58);
        if (Config.isUseGM()) {
            try {
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (matcher.matches()) {
            byte[] secretBytes = Config.getB58IdentiferCodecs().decodeAccountPrivate(b58);
            return SMKeyPair.from256Seed(secretBytes);
        }
        return Seed.getKeyPair(Config.getB58IdentiferCodecs().decodeFamilySeed(b58));
    }

    public static Seed randomSeed() {
        byte[] seedBytes = Util.getRandomBytes(16);
        return new Seed(seedBytes);
    }

    public static Seed randomSeed(byte[] version) {
        byte[] seedBytes = Util.getRandomBytes(16);
        return new Seed(version, seedBytes);
    }

    public static IKeyPair randomKeyPair() {
        byte[] seedBytes = Util.getRandomBytes(16);
        return Seed.createKeyPair(seedBytes, 0);
    }
}

