/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.sm;

import com.peersafe.base.crypto.sm.BCECUtil;
import com.peersafe.base.crypto.sm.GMBaseUtil;
import com.peersafe.base.crypto.sm.SM2Cipher;
import com.peersafe.base.crypto.sm.SM2PeersafeSigner;
import com.peersafe.base.crypto.sm.SM3Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM2Util
extends GMBaseUtil {
    public static final SM2P256V1Curve CURVE = new SM2P256V1Curve();
    public static final BigInteger SM2_ECC_P = CURVE.getQ();
    public static final BigInteger SM2_ECC_A = CURVE.getA().toBigInteger();
    public static final BigInteger SM2_ECC_B = CURVE.getB().toBigInteger();
    public static final BigInteger SM2_ECC_N = CURVE.getOrder();
    public static final BigInteger SM2_ECC_H = CURVE.getCofactor();
    public static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final org.bouncycastle.math.ec.ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
    public static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters((ECCurve)CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
    public static final int CURVE_LEN = BCECUtil.getCurveLength(DOMAIN_PARAMS);
    public static final EllipticCurve JDK_CURVE = new EllipticCurve(new ECFieldFp(SM2_ECC_P), SM2_ECC_A, SM2_ECC_B);
    public static final ECPoint JDK_G_POINT = new ECPoint(G_POINT.getAffineXCoord().toBigInteger(), G_POINT.getAffineYCoord().toBigInteger());
    public static final ECParameterSpec JDK_EC_SPEC = new ECParameterSpec(JDK_CURVE, JDK_G_POINT, SM2_ECC_N, SM2_ECC_H.intValue());
    public static final int SM3_DIGEST_LENGTH = 32;

    public static AsymmetricCipherKeyPair generateKeyPairParameter(byte[] seed) {
        SecureRandom random = new SecureRandom(seed);
        return BCECUtil.generateKeyPairParameter(DOMAIN_PARAMS, random);
    }

    public static AsymmetricCipherKeyPair generateKeyPairParameter() {
        SecureRandom random = new SecureRandom();
        return BCECUtil.generateKeyPairParameter(DOMAIN_PARAMS, random);
    }

    public static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        SecureRandom random = new SecureRandom();
        return BCECUtil.generateKeyPair(DOMAIN_PARAMS, random);
    }

    public static byte[] getRawPrivateKey(BCECPrivateKey privateKey) {
        return SM2Util.fixToCurveLengthBytes(privateKey.getD().toByteArray());
    }

    public static byte[] getRawPublicKey(BCECPublicKey publicKey) {
        byte[] src65 = publicKey.getQ().getEncoded(false);
        byte[] rawXY = new byte[CURVE_LEN * 2];
        System.arraycopy(src65, 1, rawXY, 0, rawXY.length);
        return rawXY;
    }

    public static byte[] encrypt(BCECPublicKey pubKey, byte[] srcData) throws InvalidCipherTextException {
        ECPublicKeyParameters pubKeyParameters = BCECUtil.convertPublicKeyToParameters(pubKey);
        return SM2Util.encrypt(SM2Engine.Mode.C1C3C2, pubKeyParameters, srcData);
    }

    public static byte[] encrypt(SM2Engine.Mode mode, BCECPublicKey pubKey, byte[] srcData) throws InvalidCipherTextException {
        ECPublicKeyParameters pubKeyParameters = BCECUtil.convertPublicKeyToParameters(pubKey);
        return SM2Util.encrypt(mode, pubKeyParameters, srcData);
    }

    public static byte[] encrypt(ECPublicKeyParameters pubKeyParameters, byte[] srcData) throws InvalidCipherTextException {
        return SM2Util.encrypt(SM2Engine.Mode.C1C3C2, pubKeyParameters, srcData);
    }

    public static byte[] encrypt(byte[] pubBytes, byte[] srcData) throws InvalidCipherTextException {
        byte[] ret;
        assert (pubBytes.length == 65);
        SM2Engine.Mode encryptMode = SM2Engine.Mode.C1C3C2;
        byte[] xBytes = new byte[32];
        byte[] yBytes = new byte[32];
        System.arraycopy(pubBytes, 1, xBytes, 0, 32);
        System.arraycopy(pubBytes, 33, yBytes, 0, 32);
        String xHex = ByteUtils.toHexString((byte[])xBytes);
        String yHex = ByteUtils.toHexString((byte[])yBytes);
        ECPublicKeyParameters pubKeyParameters = BCECUtil.createECPublicKeyParameters(xHex, yHex, (ECCurve)CURVE, DOMAIN_PARAMS);
        SM2Engine engine = new SM2Engine(encryptMode);
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        byte[] rawBytes = engine.processBlock(srcData, 0, srcData.length);
        try {
            ret = SM2Util.encodeSM2CipherToDER(encryptMode, rawBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = null;
        }
        return ret;
    }

    public static byte[] decrypt(byte[] privBytes, byte[] cipherDataDer) throws InvalidCipherTextException {
        SM2Engine.Mode decryptMode = SM2Engine.Mode.C1C3C2;
        byte[] cipherData = null;
        try {
            cipherData = SM2Util.decodeDERSM2Cipher(decryptMode, cipherDataDer);
        }
        catch (Exception e) {
            throw new InvalidCipherTextException(e.toString());
        }
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger(1, privBytes), DOMAIN_PARAMS);
        return SM2Util.decrypt(decryptMode, priKey, cipherData);
    }

    public static byte[] encrypt(SM2Engine.Mode mode, ECPublicKeyParameters pubKeyParameters, byte[] srcData) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        return engine.processBlock(srcData, 0, srcData.length);
    }

    public static byte[] decrypt(BCECPrivateKey priKey, byte[] sm2Cipher) throws InvalidCipherTextException {
        ECPrivateKeyParameters priKeyParameters = BCECUtil.convertPrivateKeyToParameters(priKey);
        return SM2Util.decrypt(SM2Engine.Mode.C1C3C2, priKeyParameters, sm2Cipher);
    }

    public static byte[] decrypt(SM2Engine.Mode mode, BCECPrivateKey priKey, byte[] sm2Cipher) throws InvalidCipherTextException {
        ECPrivateKeyParameters priKeyParameters = BCECUtil.convertPrivateKeyToParameters(priKey);
        return SM2Util.decrypt(mode, priKeyParameters, sm2Cipher);
    }

    public static byte[] decrypt(ECPrivateKeyParameters priKeyParameters, byte[] sm2Cipher) throws InvalidCipherTextException {
        return SM2Util.decrypt(SM2Engine.Mode.C1C3C2, priKeyParameters, sm2Cipher);
    }

    public static byte[] decrypt(SM2Engine.Mode mode, ECPrivateKeyParameters priKeyParameters, byte[] sm2Cipher) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        engine.init(false, (CipherParameters)priKeyParameters);
        return engine.processBlock(sm2Cipher, 0, sm2Cipher.length);
    }

    public static SM2Cipher parseSM2Cipher(byte[] cipherText) throws Exception {
        int curveLength = BCECUtil.getCurveLength(DOMAIN_PARAMS);
        return SM2Util.parseSM2Cipher(SM2Engine.Mode.C1C3C2, curveLength, 32, cipherText);
    }

    public static SM2Cipher parseSM2Cipher(SM2Engine.Mode mode, byte[] cipherText) throws Exception {
        int curveLength = BCECUtil.getCurveLength(DOMAIN_PARAMS);
        return SM2Util.parseSM2Cipher(mode, curveLength, 32, cipherText);
    }

    public static SM2Cipher parseSM2Cipher(int curveLength, int digestLength, byte[] cipherText) throws Exception {
        return SM2Util.parseSM2Cipher(SM2Engine.Mode.C1C3C2, curveLength, digestLength, cipherText);
    }

    public static SM2Cipher parseSM2Cipher(SM2Engine.Mode mode, int curveLength, int digestLength, byte[] cipherText) throws Exception {
        byte[] c1 = new byte[curveLength * 2 + 1];
        byte[] c2 = new byte[cipherText.length - c1.length - digestLength];
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipherText, 0, c1, 0, c1.length);
        if (mode == SM2Engine.Mode.C1C2C3) {
            System.arraycopy(cipherText, c1.length, c2, 0, c2.length);
            System.arraycopy(cipherText, c1.length + c2.length, c3, 0, c3.length);
        } else if (mode == SM2Engine.Mode.C1C3C2) {
            System.arraycopy(cipherText, c1.length, c3, 0, c3.length);
            System.arraycopy(cipherText, c1.length + c3.length, c2, 0, c2.length);
        } else {
            throw new Exception("Unsupported mode:" + mode);
        }
        SM2Cipher result = new SM2Cipher();
        result.setC1(c1);
        result.setC2(c2);
        result.setC3(c3);
        result.setCipherText(cipherText);
        return result;
    }

    public static byte[] encodeSM2CipherToDER(byte[] cipher) throws Exception {
        int curveLength = BCECUtil.getCurveLength(DOMAIN_PARAMS);
        return SM2Util.encodeSM2CipherToDER(SM2Engine.Mode.C1C3C2, curveLength, 32, cipher);
    }

    public static byte[] encodeSM2CipherToDER(SM2Engine.Mode mode, byte[] cipher) throws Exception {
        int curveLength = BCECUtil.getCurveLength(DOMAIN_PARAMS);
        return SM2Util.encodeSM2CipherToDER(mode, curveLength, 32, cipher);
    }

    public static byte[] encodeSM2CipherToDER(int curveLength, int digestLength, byte[] cipher) throws Exception {
        return SM2Util.encodeSM2CipherToDER(SM2Engine.Mode.C1C3C2, curveLength, digestLength, cipher);
    }

    public static byte[] encodeSM2CipherToDER(SM2Engine.Mode mode, int curveLength, int digestLength, byte[] cipher) throws Exception {
        byte[] c1x = new byte[curveLength];
        byte[] c1y = new byte[curveLength];
        byte[] c2 = new byte[cipher.length - c1x.length - c1y.length - 1 - digestLength];
        byte[] c3 = new byte[digestLength];
        int startPos = 1;
        System.arraycopy(cipher, startPos, c1x, 0, c1x.length);
        System.arraycopy(cipher, startPos += c1x.length, c1y, 0, c1y.length);
        startPos += c1y.length;
        if (mode == SM2Engine.Mode.C1C2C3) {
            System.arraycopy(cipher, startPos, c2, 0, c2.length);
            System.arraycopy(cipher, startPos += c2.length, c3, 0, c3.length);
        } else if (mode == SM2Engine.Mode.C1C3C2) {
            System.arraycopy(cipher, startPos, c3, 0, c3.length);
            System.arraycopy(cipher, startPos += c3.length, c2, 0, c2.length);
        } else {
            throw new Exception("Unsupported mode:" + mode);
        }
        ASN1Encodable[] arr = new ASN1Encodable[4];
        arr[0] = new ASN1Integer(c1x);
        arr[1] = new ASN1Integer(c1y);
        if (mode == SM2Engine.Mode.C1C2C3) {
            arr[2] = new DEROctetString(c2);
            arr[3] = new DEROctetString(c3);
        } else if (mode == SM2Engine.Mode.C1C3C2) {
            arr[2] = new DEROctetString(c3);
            arr[3] = new DEROctetString(c2);
        }
        DERSequence ds = new DERSequence(arr);
        return ds.getEncoded("DER");
    }

    public static byte[] decodeDERSM2Cipher(byte[] derCipher) throws Exception {
        return SM2Util.decodeDERSM2Cipher(SM2Engine.Mode.C1C3C2, derCipher);
    }

    public static byte[] decodeDERSM2Cipher(SM2Engine.Mode mode, byte[] derCipher) throws Exception {
        byte[] c3;
        byte[] c2;
        ASN1Sequence as = DERSequence.getInstance((Object)derCipher);
        byte[] c1x = ((ASN1Integer)as.getObjectAt(0)).getValue().toByteArray();
        byte[] c1y = ((ASN1Integer)as.getObjectAt(1)).getValue().toByteArray();
        if (mode == SM2Engine.Mode.C1C2C3) {
            c2 = ((DEROctetString)as.getObjectAt(2)).getOctets();
            c3 = ((DEROctetString)as.getObjectAt(3)).getOctets();
        } else if (mode == SM2Engine.Mode.C1C3C2) {
            c3 = ((DEROctetString)as.getObjectAt(2)).getOctets();
            c2 = ((DEROctetString)as.getObjectAt(3)).getOctets();
        } else {
            throw new Exception("Unsupported mode:" + mode);
        }
        int pos = 0;
        byte[] cipherText = new byte[1 + c1x.length + c1y.length + c2.length + c3.length];
        int uncompressedFlag = 4;
        cipherText[0] = 4;
        System.arraycopy(c1x, 0, cipherText, ++pos, c1x.length);
        System.arraycopy(c1y, 0, cipherText, pos += c1x.length, c1y.length);
        pos += c1y.length;
        if (mode == SM2Engine.Mode.C1C2C3) {
            System.arraycopy(c2, 0, cipherText, pos, c2.length);
            System.arraycopy(c3, 0, cipherText, pos += c2.length, c3.length);
        } else if (mode == SM2Engine.Mode.C1C3C2) {
            System.arraycopy(c3, 0, cipherText, pos, c3.length);
            System.arraycopy(c2, 0, cipherText, pos += c3.length, c2.length);
        }
        return cipherText;
    }

    public static byte[] sign(BCECPrivateKey priKey, byte[] srcData) throws CryptoException {
        ECPrivateKeyParameters priKeyParameters = BCECUtil.convertPrivateKeyToParameters(priKey);
        return SM2Util.sign(priKeyParameters, null, srcData);
    }

    public static byte[] sign(ECPrivateKeyParameters priKeyParameters, byte[] srcData) throws CryptoException {
        return SM2Util.sign(priKeyParameters, null, srcData);
    }

    public static byte[] sign(BCECPrivateKey priKey, byte[] withId, byte[] srcData) throws CryptoException {
        ECPrivateKeyParameters priKeyParameters = BCECUtil.convertPrivateKeyToParameters(priKey);
        return SM2Util.sign(priKeyParameters, withId, srcData);
    }

    public static byte[] sign(ECPrivateKeyParameters priKeyParameters, byte[] withId, byte[] srcData) throws CryptoException {
        SM2PeersafeSigner signer = new SM2PeersafeSigner();
        Object param = null;
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)priKeyParameters, new SecureRandom());
        param = withId != null ? new ParametersWithID((CipherParameters)pwr, withId) : pwr;
        byte[] msgHash = SM3Util.hash(srcData);
        signer.init(true, (CipherParameters)param);
        signer.update(msgHash, 0, msgHash.length);
        byte[] sign = signer.generateSignature();
        return sign;
    }

    public static byte[] decodeDERSM2Sign(byte[] derSign) {
        ASN1Sequence as = DERSequence.getInstance((Object)derSign);
        byte[] rBytes = ((ASN1Integer)as.getObjectAt(0)).getValue().toByteArray();
        byte[] sBytes = ((ASN1Integer)as.getObjectAt(1)).getValue().toByteArray();
        rBytes = SM2Util.fixToCurveLengthBytes(rBytes);
        sBytes = SM2Util.fixToCurveLengthBytes(sBytes);
        byte[] rawSign = new byte[rBytes.length + sBytes.length];
        System.arraycopy(rBytes, 0, rawSign, 0, rBytes.length);
        System.arraycopy(sBytes, 0, rawSign, rBytes.length, sBytes.length);
        return rawSign;
    }

    public static byte[] encodeSM2SignToDER(byte[] rawSign) throws IOException {
        BigInteger r = new BigInteger(1, SM2Util.extractBytes(rawSign, 0, 32));
        BigInteger s = new BigInteger(1, SM2Util.extractBytes(rawSign, 32, 32));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        byte[] by2 = new DERSequence(v).getEncoded("DER");
        BigInteger signR = new BigInteger(1, SM2Util.extractBytes(rawSign, 0, 32));
        BigInteger signS = new BigInteger(1, SM2Util.extractBytes(rawSign, 32, 32));
        byte[] sign = StandardDSAEncoding.INSTANCE.encode(SM2_ECC_N, signR, signS);
        return sign;
    }

    public static boolean verify(BCECPublicKey pubKey, byte[] srcData, byte[] sign) {
        ECPublicKeyParameters pubKeyParameters = BCECUtil.convertPublicKeyToParameters(pubKey);
        return SM2Util.verify(pubKeyParameters, null, srcData, sign);
    }

    public static boolean verify(ECPublicKeyParameters pubKeyParameters, byte[] srcData, byte[] sign) {
        return SM2Util.verify(pubKeyParameters, null, srcData, sign);
    }

    public static boolean verify(BCECPublicKey pubKey, byte[] withId, byte[] srcData, byte[] sign) {
        ECPublicKeyParameters pubKeyParameters = BCECUtil.convertPublicKeyToParameters(pubKey);
        return SM2Util.verify(pubKeyParameters, withId, srcData, sign);
    }

    public static boolean verify(ECPublicKeyParameters pubKeyParameters, byte[] withId, byte[] srcData, byte[] sign) {
        SM2PeersafeSigner signer = new SM2PeersafeSigner();
        Object param = withId != null ? new ParametersWithID((CipherParameters)pubKeyParameters, withId) : pubKeyParameters;
        byte[] srcHash = SM3Util.hash(srcData);
        signer.init(false, (CipherParameters)param);
        signer.update(srcHash, 0, srcHash.length);
        return signer.verifySignature(sign);
    }

    private static byte[] extractBytes(byte[] src, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(src, offset, result, 0, result.length);
        return result;
    }

    private static byte[] fixToCurveLengthBytes(byte[] src) {
        if (src.length == CURVE_LEN) {
            return src;
        }
        byte[] result = new byte[CURVE_LEN];
        if (src.length > CURVE_LEN) {
            System.arraycopy(src, src.length - result.length, result, 0, result.length);
        } else {
            System.arraycopy(src, 0, result, result.length - src.length, src.length);
        }
        return result;
    }
}

